/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.items;

import java.util.ArrayList;
import java.util.List;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.IGrantsManifestations;
import leaf.cosmere.api.IHasSize;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.items.MetalNuggetItem;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GodMetalNuggetItem
extends MetalNuggetItem
implements IHasSize,
IGrantsManifestations {
    public static int MIN_SIZE = 1;
    public static int MAX_SIZE = 16;

    public GodMetalNuggetItem(Metals.MetalType metalType) {
        super(metalType);
    }

    @Override
    public int getMaxSize() {
        return MAX_SIZE;
    }

    @Override
    public int getMinSize() {
        return MIN_SIZE;
    }

    public void m_7836_(ItemStack itemStack, Level level, Player player) {
        CompoundTag nbt = itemStack.m_41784_();
        if (!nbt.m_128441_("nuggetSize")) {
            this.writeMetalAlloySizeNbtData(itemStack, this.getMaxSize());
        }
    }

    @Override
    public ItemStack m_5922_(ItemStack itemstack, Level pLevel, LivingEntity pLivingEntity) {
        Player player;
        if (pLevel.f_46443_) {
            return itemstack;
        }
        if (pLivingEntity instanceof Player && !(player = (Player)pLivingEntity).m_7500_()) {
            itemstack.m_41774_(1);
        }
        return itemstack;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return ItemStack.f_41583_;
    }

    public boolean m_5812_(ItemStack itemStack) {
        return super.m_5812_(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Integer size = this.readMetalAlloySizeNbtData(stack);
        tooltip.add((Component)Component.m_237113_((String)"Size: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)(size + "/" + MAX_SIZE)).m_130940_(ChatFormatting.GRAY)));
        ArrayList<Manifestation> manifestations = this.determineManifestations(stack);
        if (!manifestations.isEmpty()) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237113_((String)"When consumed:").m_130940_(ChatFormatting.GOLD));
            for (Manifestation manifestation : manifestations) {
                tooltip.add((Component)Component.m_237113_((String)("+" + size + " ")).m_7220_((Component)Component.m_237115_((String)manifestation.getTranslationKey())).m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    public boolean m_142305_(ItemStack pStack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        return false;
    }

    @Override
    public ArrayList<Manifestation> determineManifestations(ItemStack itemStack) {
        ArrayList<Manifestation> manifestations;
        block3: {
            block2: {
                manifestations = new ArrayList<Manifestation>();
                if (this.getMetalType() != Metals.MetalType.LERASIUM) break block2;
                for (Metals.MetalType metal : EnumUtils.METAL_TYPES) {
                    Manifestation manifestation = Manifestations.ManifestationTypes.ALLOMANCY.getManifestation(metal.getID());
                    if (manifestation.getManifestationType() == Manifestations.ManifestationTypes.NONE) continue;
                    manifestations.add(manifestation);
                }
                break block3;
            }
            if (this.getMetalType() != Metals.MetalType.LERASATIUM) break block3;
            for (Metals.MetalType metal : EnumUtils.METAL_TYPES) {
                Manifestation manifestation = Manifestations.ManifestationTypes.FERUCHEMY.getManifestation(metal.getID());
                if (manifestation.getManifestationType() == Manifestations.ManifestationTypes.NONE) continue;
                manifestations.add(manifestation);
            }
        }
        return manifestations;
    }

    @Override
    public void grantManifestations(LivingEntity livingEntity, ArrayList<Manifestation> manifestations, int strength) {
        SpiritwebCapability.get(livingEntity).ifPresent(iSpiritweb -> {
            SpiritwebCapability spiritweb = (SpiritwebCapability)iSpiritweb;
            for (Manifestation manifestation : manifestations) {
                int newStrength;
                int currentStrength = 0;
                Attribute patt4732$temp = manifestation.getAttribute();
                if (!(patt4732$temp instanceof RangedAttribute)) {
                    return;
                }
                RangedAttribute attribute = (RangedAttribute)patt4732$temp;
                AttributeInstance attributeInstance = livingEntity.m_21051_((Attribute)attribute);
                if (attributeInstance != null) {
                    currentStrength = (int)attributeInstance.m_22135_();
                }
                if ((double)(newStrength = strength + currentStrength) < attribute.m_147361_()) {
                    newStrength = (int)attribute.m_147361_();
                } else if ((double)newStrength > attribute.m_147362_()) {
                    newStrength = (int)attribute.m_147362_();
                }
                spiritweb.giveManifestation(manifestation, newStrength);
            }
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                spiritweb.syncToClients(serverPlayer);
            }
        });
    }
}

