/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import leaf.cosmere.api.IHasMetalType;
import leaf.cosmere.common.registry.LootFunctionRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class RandomiseMetalTypeLootFunction
extends LootItemConditionalFunction {
    protected RandomiseMetalTypeLootFunction(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)LootFunctionRegistry.RANDOMISE_METALTYPE.get();
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext lootContext) {
        Item item = stack.m_41720_();
        if (!(item instanceof IHasMetalType)) {
            return stack;
        }
        ArrayList<Item> itemsOfClass = new ArrayList<Item>();
        block3: for (Item value : ForgeRegistries.ITEMS.getValues()) {
            if (!value.getClass().equals(item.getClass())) continue;
            IHasMetalType iHasMetalType = (IHasMetalType)value;
            switch (iHasMetalType.getMetalType()) {
                case LERASIUM: 
                case HARMONIUM: 
                case LERASATIUM: {
                    continue block3;
                }
            }
            itemsOfClass.add(value);
        }
        Collections.shuffle(itemsOfClass);
        Optional random = itemsOfClass.stream().findFirst();
        if (random.isPresent()) {
            CompoundTag nbt = stack.m_41784_().m_6426_();
            stack = new ItemStack((ItemLike)random.get(), stack.m_41613_());
            stack.m_41751_(nbt);
        }
        return stack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RandomiseMetalTypeLootFunction> {
        public RandomiseMetalTypeLootFunction deserialize(JsonObject jsonObject, JsonDeserializationContext deserializationContext, LootItemCondition[] lootConditions) {
            return new RandomiseMetalTypeLootFunction(lootConditions);
        }
    }
}

