/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.recipes;

import javax.annotation.Nonnull;
import leaf.cosmere.api.IHasSize;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.providers.IItemProvider;
import leaf.cosmere.common.items.GodMetalAlloyNuggetItem;
import leaf.cosmere.common.items.GodMetalNuggetItem;
import leaf.cosmere.common.items.MetalNuggetItem;
import leaf.cosmere.common.registry.CosmereRecipesRegistry;
import leaf.cosmere.common.registry.ItemsRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GodMetalAlloyNuggetRecipe
extends CustomRecipe {
    public GodMetalAlloyNuggetRecipe(ResourceLocation loc, CraftingBookCategory pCategory) {
        super(loc, pCategory);
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        Ingredient INGREDIENT_GOD_METAL_NUG = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ItemsRegistry.GOD_METAL_NUGGETS.get((Object)Metals.MetalType.LERASIUM), ItemsRegistry.GOD_METAL_NUGGETS.get((Object)Metals.MetalType.LERASATIUM)});
        Ingredient INGREDIENT_COSMERE_METAL_NUG = Ingredient.m_43921_(ItemsRegistry.METAL_NUGGETS.values().stream().map(IItemProvider::getItemStack));
        Ingredient INGREDIENT_MC_METAL_NUG = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42749_, Items.f_42587_});
        if (!INGREDIENT_GOD_METAL_NUG.test(inv.m_8020_(4))) {
            return false;
        }
        if (inv.m_8020_(4).m_41613_() != 1) {
            return false;
        }
        Metals.MetalType metalType = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            MetalNuggetItem item;
            if (i == 4) continue;
            ItemStack itemStack = inv.m_8020_(i);
            if (INGREDIENT_COSMERE_METAL_NUG.test(itemStack)) {
                item = (MetalNuggetItem)itemStack.m_41720_();
                if (i == 0) {
                    metalType = item.getMetalType();
                }
                if (metalType == item.getMetalType()) continue;
                return false;
            }
            if (INGREDIENT_MC_METAL_NUG.test(itemStack)) {
                Metals.MetalType newMetalType;
                item = itemStack.m_41720_();
                if (item == Items.f_42749_) {
                    newMetalType = Metals.MetalType.IRON;
                } else if (item == Items.f_42587_) {
                    newMetalType = Metals.MetalType.GOLD;
                } else {
                    return false;
                }
                if (i == 0) {
                    metalType = newMetalType;
                }
                if (metalType == newMetalType) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess pRegistryAccess) {
        GodMetalNuggetItem godMetalNuggetItem = (GodMetalNuggetItem)inv.m_8020_(4).m_41720_();
        Metals.MetalType godMetalType = godMetalNuggetItem.getMetalType();
        Metals.MetalType metalType = null;
        if (inv.m_8020_(0).m_41720_() == Items.f_42749_) {
            metalType = Metals.MetalType.IRON;
        } else if (inv.m_8020_(0).m_41720_() == Items.f_42587_) {
            metalType = Metals.MetalType.GOLD;
        } else {
            MetalNuggetItem metalNuggetItem = (MetalNuggetItem)inv.m_8020_(0).m_41720_();
            metalType = metalNuggetItem.getMetalType();
        }
        ItemStack itemStack = new ItemStack((ItemLike)ItemsRegistry.GOD_METAL_ALLOY_NUGGETS.get((Object)godMetalType).get((Object)metalType));
        GodMetalAlloyNuggetItem item = (GodMetalAlloyNuggetItem)itemStack.m_41720_();
        item.writeMetalAlloySizeNbtData(itemStack, 2);
        itemStack.m_41764_(8);
        return itemStack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height == 9;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return new ResourceLocation("cosmere", "god_metal_alloy_nugget_recipe");
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CosmereRecipesRegistry.GOD_METAL_ALLOY_NUGGET_RECIPE.get();
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pContainer) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)pContainer.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = pContainer.m_8020_(i);
            if (!item.hasCraftingRemainingItem()) continue;
            nonnulllist.set(i, (Object)this.getCraftingRemainingItem(item));
        }
        return nonnulllist;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        ItemStack out = stack.m_41777_();
        IHasSize item = (IHasSize)stack.m_41720_();
        int size = item.readMetalAlloySizeNbtData(stack);
        int newSize = size - 1;
        if (newSize < 1) {
            return ItemStack.f_41583_;
        }
        item.writeMetalAlloySizeNbtData(out, newSize);
        return out;
    }
}

