/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.registration.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.providers.IEntityTypeProvider;
import leaf.cosmere.common.registration.WrappedDeferredRegister;
import leaf.cosmere.common.registration.impl.EntityTypeRegistryObject;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityTypeDeferredRegister
extends WrappedDeferredRegister<EntityType<?>> {
    private Map<EntityTypeRegistryObject<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>> livingEntityAttributes = new HashMap<EntityTypeRegistryObject<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>>();
    private final List<IEntityTypeProvider> allEntityTypes = new ArrayList<IEntityTypeProvider>();

    public EntityTypeDeferredRegister(String modid) {
        super(modid, ForgeRegistries.ENTITY_TYPES);
    }

    public <ENTITY extends LivingEntity> EntityTypeRegistryObject<ENTITY> register(String name, EntityType.Builder<ENTITY> builder, Supplier<AttributeSupplier.Builder> attributes) {
        EntityTypeRegistryObject<ENTITY> entityTypeRO = this.register(name, builder);
        this.livingEntityAttributes.put(entityTypeRO, attributes);
        return entityTypeRO;
    }

    public <ENTITY extends Entity> EntityTypeRegistryObject<ENTITY> register(String name, EntityType.Builder<ENTITY> builder) {
        EntityTypeRegistryObject registryObject = this.register(name, () -> builder.m_20712_(name), EntityTypeRegistryObject::new);
        this.allEntityTypes.add(registryObject);
        return registryObject;
    }

    @Override
    public void register(IEventBus bus) {
        super.register(bus);
        bus.addListener(this::registerEntityAttributes);
    }

    private void registerEntityAttributes(EntityAttributeCreationEvent event) {
        if (this.livingEntityAttributes == null) {
            CosmereAPI.logger.error("GlobalEntityTypeAttributes have already been set. This should not happen.");
        } else {
            for (Map.Entry<EntityTypeRegistryObject<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>> entry : this.livingEntityAttributes.entrySet()) {
                event.put((EntityType)entry.getKey().get(), entry.getValue().get().m_22265_());
            }
            this.livingEntityAttributes = null;
        }
    }

    public List<IEntityTypeProvider> getAllEntityTypes() {
        return Collections.unmodifiableList(this.allEntityTypes);
    }
}

