/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.registration.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import leaf.cosmere.api.providers.IItemProvider;
import leaf.cosmere.common.registration.WrappedDeferredRegister;
import leaf.cosmere.common.registration.impl.EntityTypeRegistryObject;
import leaf.cosmere.common.registration.impl.ItemRegistryObject;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemDeferredRegister
extends WrappedDeferredRegister<Item> {
    private final List<IItemProvider> allItems = new ArrayList<IItemProvider>();

    public ItemDeferredRegister(String modid) {
        super(modid, ForgeRegistries.ITEMS);
    }

    public static Item.Properties getCosmereDefaultProperties() {
        return new Item.Properties();
    }

    public ItemRegistryObject<Item> register(String name) {
        return this.register(name, Item::new);
    }

    public ItemRegistryObject<Item> registerUnburnable(String name) {
        return this.registerUnburnable(name, Item::new);
    }

    public ItemRegistryObject<Item> register(String name, Rarity rarity) {
        return this.register(name, (Item.Properties properties) -> new Item(properties.m_41497_(rarity)));
    }

    public <ITEM extends Item> ItemRegistryObject<ITEM> register(String name, Function<Item.Properties, ITEM> sup) {
        return this.register(name, () -> (Item)sup.apply(ItemDeferredRegister.getCosmereDefaultProperties()));
    }

    public <ITEM extends Item> ItemRegistryObject<ITEM> registerUnburnable(String name, Function<Item.Properties, ITEM> sup) {
        return this.register(name, () -> (Item)sup.apply(ItemDeferredRegister.getCosmereDefaultProperties().m_41486_()));
    }

    public <ITEM extends Item> ItemRegistryObject<ITEM> register(String name, Supplier<? extends ITEM> sup) {
        ItemRegistryObject registeredItem = this.register(name, sup, ItemRegistryObject::new);
        this.allItems.add(registeredItem);
        return registeredItem;
    }

    public <ENTITY extends Mob> ItemRegistryObject<ForgeSpawnEggItem> registerSpawnEgg(EntityTypeRegistryObject<ENTITY> entityTypeProvider, int primaryColor, int secondaryColor) {
        return this.register(entityTypeProvider.getInternalRegistryName() + "_spawn_egg", (Item.Properties props) -> new ForgeSpawnEggItem((Supplier)entityTypeProvider, primaryColor, secondaryColor, props));
    }

    public List<IItemProvider> getAllItems() {
        return Collections.unmodifiableList(this.allItems);
    }
}

