/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.registry;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Metals;
import leaf.cosmere.common.blocks.MetalBlock;
import leaf.cosmere.common.blocks.MetalOreBlock;
import leaf.cosmere.common.blocks.MetalworkingTableBlock;
import leaf.cosmere.common.registration.impl.BlockDeferredRegister;
import leaf.cosmere.common.registration.impl.BlockRegistryObject;
import leaf.cosmere.common.resource.ore.OreBlockType;
import leaf.cosmere.common.resource.ore.OreType;
import leaf.cosmere.common.util.CosmereEnumUtils;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;

public class BlocksRegistry {
    public static final BlockDeferredRegister BLOCKS = new BlockDeferredRegister("cosmere");
    public static final BlockRegistryObject<Block, BlockItem> METALWORKING_TABLE = BLOCKS.register("metalworking_table", MetalworkingTableBlock::new);
    public static final Map<Metals.MetalType, BlockRegistryObject<MetalBlock, BlockItem>> METAL_BLOCKS = Arrays.stream(EnumUtils.METAL_TYPES).filter(type -> type.hasMaterialItem() && type != Metals.MetalType.COPPER).collect(Collectors.toMap(Function.identity(), metalType -> BLOCKS.registerWithRarity(metalType.m_6082_() + "_block", () -> new MetalBlock((Metals.MetalType)((Object)metalType)), metalType.getRarity())));
    public static final Map<OreType, OreBlockType> METAL_ORE = Arrays.stream(CosmereEnumUtils.ORE_TYPES).collect(Collectors.toMap(Function.identity(), oreType -> {
        Metals.MetalType metalType = oreType.getMetalType();
        BlockRegistryObject<MetalOreBlock, BlockItem> stoneOre = BLOCKS.registerWithRarity(metalType.m_6082_() + "_ore", () -> new MetalOreBlock(metalType), metalType.getRarity());
        BlockRegistryObject<MetalOreBlock, BlockItem> deepslateOre = BLOCKS.registerWithRarity("deepslate_" + metalType.m_6082_() + "_ore", () -> new MetalOreBlock(metalType), metalType.getRarity());
        return new OreBlockType(stoneOre, deepslateOre);
    }));
}

