/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.world;

import java.util.BitSet;
import java.util.function.Function;
import leaf.cosmere.common.world.ResizableOreFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import org.jetbrains.annotations.NotNull;

public class ResizableOreFeature
extends Feature<ResizableOreFeatureConfig> {
    public ResizableOreFeature() {
        super(ResizableOreFeatureConfig.CODEC);
    }

    protected Heightmap.Types getHeightmapType() {
        return Heightmap.Types.OCEAN_FLOOR_WG;
    }

    public boolean m_142674_(@NotNull FeaturePlaceContext<ResizableOreFeatureConfig> context) {
        RandomSource random = context.m_225041_();
        BlockPos pos = context.m_159777_();
        WorldGenLevel world = context.m_159774_();
        ResizableOreFeatureConfig config = (ResizableOreFeatureConfig)context.m_159778_();
        float angle = random.m_188501_() * (float)Math.PI;
        float adjustedSize = (float)((Integer)config.size().get()).intValue() / 8.0f;
        int i = Mth.m_14167_((float)((adjustedSize + 1.0f) / 2.0f));
        double sin = Math.sin(angle) * (double)adjustedSize;
        double cos = Math.cos(angle) * (double)adjustedSize;
        double xMin = (double)pos.m_123341_() + sin;
        double xMax = (double)pos.m_123341_() - sin;
        double zMin = (double)pos.m_123343_() + cos;
        double zMax = (double)pos.m_123343_() - cos;
        double yMin = pos.m_123342_() + random.m_188503_(3) - 2;
        double yMax = pos.m_123342_() + random.m_188503_(3) - 2;
        int minXStart = pos.m_123341_() - Mth.m_14167_((float)adjustedSize) - i;
        int minYStart = pos.m_123342_() - 2 - i;
        int minZStart = pos.m_123343_() - Mth.m_14167_((float)adjustedSize) - i;
        int width = 2 * (Mth.m_14167_((float)adjustedSize) + i);
        int height = 2 * (2 + i);
        for (int x = minXStart; x <= minXStart + width; ++x) {
            for (int z = minZStart; z <= minZStart + width; ++z) {
                if (minYStart > world.m_6924_(this.getHeightmapType(), x, z)) continue;
                return this.doPlace(world, random, config, xMin, xMax, zMin, zMax, yMin, yMax, minXStart, minYStart, minZStart, width, height);
            }
        }
        return false;
    }

    protected boolean doPlace(WorldGenLevel world, RandomSource random, ResizableOreFeatureConfig config, double xMin, double xMax, double zMin, double zMax, double yMin, double yMax, int minXStart, int minYStart, int minZStart, int width, int height) {
        int i;
        BitSet bitset = new BitSet(width * height * width);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int size = (Integer)config.size().get();
        double[] adouble = new double[size * 4];
        for (int k = 0; k < size; ++k) {
            float f = (float)k / (float)size;
            int k4 = k * 4;
            adouble[k4] = Mth.m_14139_((double)f, (double)xMin, (double)xMax);
            adouble[k4 + 1] = Mth.m_14139_((double)f, (double)yMin, (double)yMax);
            adouble[k4 + 2] = Mth.m_14139_((double)f, (double)zMin, (double)zMax);
            double d3 = random.m_188500_() * (double)size / 16.0;
            adouble[k4 + 3] = ((double)(Mth.m_14031_((float)((float)Math.PI * f)) + 1.0f) * d3 + 1.0) / 2.0;
        }
        for (i = 0; i < size - 1; ++i) {
            int i4 = i * 4;
            if (!(adouble[i4 + 3] > 0.0)) continue;
            for (int j = i + 1; j < size; ++j) {
                double d3;
                double d2;
                double d1;
                double d4;
                int j4 = j * 4;
                if (!(adouble[j4 + 3] > 0.0) || !((d4 = adouble[i4 + 3] - adouble[j4 + 3]) * d4 > (d1 = adouble[i4] - adouble[j4]) * d1 + (d2 = adouble[i4 + 1] - adouble[j4 + 1]) * d2 + (d3 = adouble[i4 + 2] - adouble[j4 + 2]) * d3)) continue;
                if (d4 > 0.0) {
                    adouble[j4 + 3] = -1.0;
                    continue;
                }
                adouble[i4 + 3] = -1.0;
            }
        }
        i = 0;
        try (BulkSectionAccess bulkSectionAccess = new BulkSectionAccess((LevelAccessor)world);){
            double discardChanceOnAirExposure = (Double)config.discardChanceOnAirExposure().get();
            for (int j = 0; j < size; ++j) {
                int j4 = j * 4;
                double d1 = adouble[j4 + 3];
                if (!(d1 >= 0.0)) continue;
                double d2 = adouble[j4];
                double d3 = adouble[j4 + 1];
                double d4 = adouble[j4 + 2];
                int xStart = Math.max(Mth.m_14107_((double)(d2 - d1)), minXStart);
                int yStart = Math.max(Mth.m_14107_((double)(d3 - d1)), minYStart);
                int zStart = Math.max(Mth.m_14107_((double)(d4 - d1)), minZStart);
                int xEnd = Math.max(Mth.m_14107_((double)(d2 + d1)), xStart);
                int yEnd = Math.max(Mth.m_14107_((double)(d3 + d1)), yStart);
                int zEnd = Math.max(Mth.m_14107_((double)(d4 + d1)), zStart);
                for (int x = xStart; x <= xEnd; ++x) {
                    double d5 = ((double)x + 0.5 - d2) / d1;
                    double d5_squared = d5 * d5;
                    if (!(d5_squared < 1.0)) continue;
                    for (int y = yStart; y <= yEnd; ++y) {
                        double d6 = ((double)y + 0.5 - d3) / d1;
                        double d6_squared = d6 * d6;
                        if (!(d5_squared + d6_squared < 1.0)) continue;
                        block11: for (int z = zStart; z <= zEnd; ++z) {
                            LevelChunkSection section;
                            int l2;
                            double d7 = ((double)z + 0.5 - d4) / d1;
                            if (!(d5_squared + d6_squared + d7 * d7 < 1.0) || world.m_151562_(y) || bitset.get(l2 = x - minXStart + (y - minYStart) * width + (z - minZStart) * width * height)) continue;
                            bitset.set(l2);
                            mutablePos.m_122178_(x, y, z);
                            if (!world.m_180807_((BlockPos)mutablePos) || (section = bulkSectionAccess.m_156104_((BlockPos)mutablePos)) == null) continue;
                            int sectionX = SectionPos.m_123207_((int)x);
                            int sectionY = SectionPos.m_123207_((int)y);
                            int sectionZ = SectionPos.m_123207_((int)z);
                            BlockState state = section.m_62982_(sectionX, sectionY, sectionZ);
                            for (OreConfiguration.TargetBlockState targetState : config.targetStates()) {
                                if (!ResizableOreFeature.canPlaceOre(state, arg_0 -> ((BulkSectionAccess)bulkSectionAccess).m_156110_(arg_0), random, discardChanceOnAirExposure, targetState, mutablePos)) continue;
                                section.m_62991_(sectionX, sectionY, sectionZ, targetState.f_161033_, false);
                                ++i;
                                continue block11;
                            }
                        }
                    }
                }
            }
        }
        return i > 0;
    }

    private static boolean canPlaceOre(BlockState state, Function<BlockPos, BlockState> adjacentStateAccessor, RandomSource random, double discardChanceOnAirExposure, OreConfiguration.TargetBlockState targetState, BlockPos.MutableBlockPos mutablePos) {
        if (!targetState.f_161032_.m_213865_(state, random)) {
            return false;
        }
        if (ResizableOreFeature.shouldSkipAirCheck(random, discardChanceOnAirExposure)) {
            return true;
        }
        return !ResizableOreFeature.m_159750_(adjacentStateAccessor, (BlockPos)mutablePos);
    }

    private static boolean shouldSkipAirCheck(RandomSource random, double discardChanceOnAirExposure) {
        if (discardChanceOnAirExposure <= 0.0) {
            return true;
        }
        if (discardChanceOnAirExposure >= 1.0) {
            return false;
        }
        return (double)random.m_188501_() >= discardChanceOnAirExposure;
    }
}

