/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api;

import java.awt.Color;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import leaf.cosmere.api.EnumUtils;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;

public class Roshar {

    public static enum RadiantOrder {
        WINDRUNNER(Gemstone.SAPPHIRE),
        SKYBREAKER(Gemstone.SMOKESTONE),
        DUSTBRINGER(Gemstone.RUBY),
        EDGEDANCER(Gemstone.DIAMOND),
        TRUTHWATCHER(Gemstone.EMERALD),
        LIGHTWEAVER(Gemstone.GARNET),
        ELSECALLER(Gemstone.ZIRCON),
        WILLSHAPER(Gemstone.AMETHYST),
        STONEWARD(Gemstone.TOPAZ),
        BONDSMITH(Gemstone.HELIODOR);

        private final Gemstone gemstone;

        private RadiantOrder(Gemstone gemstone) {
            this.gemstone = gemstone;
        }

        public static Optional<RadiantOrder> valueOf(int value) {
            return Arrays.stream(EnumUtils.RADIANT_ORDERS).filter(order -> order.getID() == value).findFirst();
        }

        public int getID() {
            return this.gemstone.getID();
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public Surges getFirstSurge() {
            switch (this) {
                default: {
                    return Surges.ADHESION;
                }
                case SKYBREAKER: {
                    return Surges.GRAVITATION;
                }
                case DUSTBRINGER: {
                    return Surges.DIVISION;
                }
                case EDGEDANCER: {
                    return Surges.ABRASION;
                }
                case TRUTHWATCHER: {
                    return Surges.PROGRESSION;
                }
                case LIGHTWEAVER: {
                    return Surges.ILLUMINATION;
                }
                case ELSECALLER: {
                    return Surges.TRANSFORMATION;
                }
                case WILLSHAPER: {
                    return Surges.TRANSPORTATION;
                }
                case STONEWARD: {
                    return Surges.COHESION;
                }
                case BONDSMITH: 
            }
            return Surges.TENSION;
        }

        public Surges getSecondSurge() {
            switch (this) {
                default: {
                    return Surges.GRAVITATION;
                }
                case SKYBREAKER: {
                    return Surges.DIVISION;
                }
                case DUSTBRINGER: {
                    return Surges.ABRASION;
                }
                case EDGEDANCER: {
                    return Surges.PROGRESSION;
                }
                case TRUTHWATCHER: {
                    return Surges.ILLUMINATION;
                }
                case LIGHTWEAVER: {
                    return Surges.TRANSFORMATION;
                }
                case ELSECALLER: {
                    return Surges.TRANSPORTATION;
                }
                case WILLSHAPER: {
                    return Surges.COHESION;
                }
                case STONEWARD: {
                    return Surges.TENSION;
                }
                case BONDSMITH: 
            }
            return Surges.ADHESION;
        }

        public int getColorValue() {
            return this.getColor().getRGB();
        }

        public Color getColor() {
            return this.gemstone.getColor();
        }
    }

    private static class GemColours {
        public static final Color SAPPHIRE = Color.decode("#3991f3");
        public static final Color SMOKESTONE = Color.decode("#c0a6b3");
        public static final Color RUBY = Color.decode("#b40502");
        public static final Color DIAMOND = Color.decode("#f5faf3");
        public static final Color EMERALD = Color.decode("#52b984");
        public static final Color GARNET = Color.decode("#e03935");
        public static final Color ZIRCON = Color.decode("#3ab7bb");
        public static final Color AMETHYST = Color.decode("#c975e4");
        public static final Color TOPAZ = Color.decode("#e3681a");
        public static final Color HELIODOR = Color.decode("#f3dd25");

        private GemColours() {
        }
    }

    public static enum Gemstone implements Tier
    {
        SAPPHIRE(0),
        SMOKESTONE(1),
        RUBY(2),
        DIAMOND(3),
        EMERALD(4),
        GARNET(5),
        ZIRCON(6),
        AMETHYST(7),
        TOPAZ(8),
        HELIODOR(9);

        private final int id;

        private Gemstone(int id) {
            this.id = id;
        }

        public static Optional<Gemstone> valueOf(int value) {
            return Arrays.stream(Gemstone.values()).filter(gemType -> gemType.id == value).findFirst();
        }

        public int getID() {
            return this.id;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public RadiantOrder getAssociatedOrder() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case SAPPHIRE -> RadiantOrder.WINDRUNNER;
                case SMOKESTONE -> RadiantOrder.SKYBREAKER;
                case RUBY -> RadiantOrder.DUSTBRINGER;
                case DIAMOND -> RadiantOrder.EDGEDANCER;
                case EMERALD -> RadiantOrder.TRUTHWATCHER;
                case GARNET -> RadiantOrder.LIGHTWEAVER;
                case ZIRCON -> RadiantOrder.ELSECALLER;
                case AMETHYST -> RadiantOrder.WILLSHAPER;
                case TOPAZ -> RadiantOrder.STONEWARD;
                case HELIODOR -> RadiantOrder.BONDSMITH;
            };
        }

        public int getColorValue() {
            return this.getColor().getRGB();
        }

        public Color getColor() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case SAPPHIRE -> GemColours.SAPPHIRE;
                case SMOKESTONE -> GemColours.SMOKESTONE;
                case RUBY -> GemColours.RUBY;
                case DIAMOND -> GemColours.DIAMOND;
                case EMERALD -> GemColours.EMERALD;
                case GARNET -> GemColours.GARNET;
                case ZIRCON -> GemColours.ZIRCON;
                case AMETHYST -> GemColours.AMETHYST;
                case TOPAZ -> GemColours.TOPAZ;
                case HELIODOR -> GemColours.HELIODOR;
            };
        }

        public int m_6609_() {
            return 0;
        }

        public float m_6624_() {
            return 0.0f;
        }

        public float m_6631_() {
            return 0.0f;
        }

        public int m_6604_() {
            return 0;
        }

        public int m_6601_() {
            return 0;
        }

        public Ingredient m_6282_() {
            return null;
        }
    }

    public static enum Surges {
        ADHESION(0),
        GRAVITATION(1),
        DIVISION(2),
        ABRASION(3),
        PROGRESSION(4),
        ILLUMINATION(5),
        TRANSFORMATION(6),
        TRANSPORTATION(7),
        COHESION(8),
        TENSION(9);

        private final int id;

        private Surges(int id) {
            this.id = id;
        }

        public static Optional<Surges> valueOf(int value) {
            return Arrays.stream(Surges.values()).filter(surge -> surge.id == value).findFirst();
        }

        public int getID() {
            return this.id;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum GemSize {
        BROAM,
        MARK,
        CHIP;


        public float getChargeModifier() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case BROAM -> 1.0f;
                case MARK -> 0.5f;
                case CHIP -> 0.1f;
            };
        }
    }
}

