/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api.cosmereEffect;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class AttributeModifierInfo {
    private final Attribute attribute;
    private double amountPerPointOfStrength;
    private AttributeModifier.Operation operation;

    public AttributeModifierInfo(Attribute attribute, double amountPerPointOfStrength, AttributeModifier.Operation operation) {
        this.attribute = attribute;
        this.amountPerPointOfStrength = amountPerPointOfStrength;
        this.operation = operation;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public double getAmount() {
        return this.amountPerPointOfStrength;
    }

    public AttributeModifier.Operation getOperation() {
        return this.operation;
    }

    public void update(double strength, AttributeModifier.Operation operation) {
        this.amountPerPointOfStrength = strength;
        this.operation = operation;
    }

    public Tag save(CompoundTag compoundTag) {
        compoundTag.m_128359_("attribute_id", ForgeRegistries.ATTRIBUTES.getKey((Object)this.attribute).toString());
        compoundTag.m_128347_("amount", this.amountPerPointOfStrength);
        compoundTag.m_128405_("operation", this.operation.m_22235_());
        return compoundTag;
    }

    public static AttributeModifierInfo load(CompoundTag tag) {
        ResourceLocation attributeID = new ResourceLocation(tag.m_128461_("attribute_id"));
        if (ForgeRegistries.ATTRIBUTES.containsKey(attributeID)) {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeID);
            double amount = tag.m_128459_("amount");
            AttributeModifier.Operation op = AttributeModifier.Operation.m_22236_((int)tag.m_128451_("operation"));
            return new AttributeModifierInfo(attribute, amount, op);
        }
        return null;
    }
}

