/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class DrawHelper {
    public static void drawLinesFromPoint(PoseStack poseStack, Vec3 originPoint, float range, Color color, List<Vec3> lineEndPositions, Vec3 highlightVector) {
        poseStack.m_85836_();
        Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer bufferIn = bufferSource.m_6299_(CosmereAPIRenderTypes.LINE_OVERLAY.get());
        for (Vec3 endPos : lineEndPositions) {
            Color finalColor = color;
            if (highlightVector != null && endPos.equals((Object)highlightVector)) {
                finalColor = Color.decode("#66b2ff");
            }
            int alpha = (int)Math.max(0.0, Math.floor((1.0 - originPoint.m_82554_(endPos) / (double)range) * (double)finalColor.getAlpha()));
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            Matrix3f normal = poseStack.m_85850_().m_252943_();
            bufferIn.m_252986_(matrix, (float)originPoint.m_7096_(), (float)originPoint.m_7098_(), (float)originPoint.m_7094_()).m_6122_(finalColor.getRed(), finalColor.getGreen(), finalColor.getBlue(), alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            bufferIn.m_252986_(matrix, (float)endPos.m_7096_(), (float)endPos.m_7098_(), (float)endPos.m_7094_()).m_6122_(finalColor.getRed(), finalColor.getGreen(), finalColor.getBlue(), alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        }
        bufferSource.m_109912_(CosmereAPIRenderTypes.LINE_OVERLAY.get());
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
    }

    public static void drawSquareAtPoint(PoseStack pStack, Color color, List<Vec3> squarePosList, Vec3 destinationVec) {
        pStack.m_85836_();
        Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pStack.m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
        RenderSystem.setShader(GameRenderer::m_172817_);
        ResourceLocation icon = new ResourceLocation("minecraft", "textures/particle/note.png");
        RenderType RENDER_TYPE = CosmereAPIRenderTypes.SQUARE_TEX_OVERLAY(icon);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer bufferIn = bufferSource.m_6299_(RENDER_TYPE);
        float size = 0.3f;
        for (Vec3 pos : squarePosList) {
            Vec3 directionalVec = pos.m_82546_(destinationVec).m_82541_();
            Matrix4f matrix4f = pStack.m_85850_().m_252922_();
            Matrix3f matrix3f = pStack.m_85850_().m_252943_();
            double pitch = Math.asin(-directionalVec.f_82480_);
            double yaw = Math.atan2(directionalVec.f_82479_, directionalVec.f_82481_);
            Quaternionf rotQuat = Axis.f_252436_.m_252977_((float)Math.toDegrees(yaw));
            rotQuat.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)Math.toDegrees(pitch) + 90.0f));
            float[] vertices = new float[]{-0.3f, 0.0f, -0.3f, -0.3f, 0.0f, 0.3f, 0.3f, 0.0f, 0.3f, 0.3f, 0.0f, -0.3f};
            float[] textureCoords = new float[]{1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f};
            for (int i = 0; i < vertices.length; i += 3) {
                float vertexX = vertices[i];
                float vertexY = vertices[i + 1];
                float vertexZ = vertices[i + 2];
                Vector3f rotQuatVec = new Vector3f(vertexX, vertexY, vertexZ);
                rotQuatVec.rotate((Quaternionfc)rotQuat);
                float finalX = (float)((double)rotQuatVec.x() + pos.m_7096_());
                float finalY = (float)((double)rotQuatVec.y() + pos.m_7098_());
                float finalZ = (float)((double)rotQuatVec.z() + pos.m_7094_());
                int textureUCoord = (int)textureCoords[i / 3 * 2];
                int textureVCoord = (int)textureCoords[i / 3 * 2 + 1];
                DrawHelper.squareTexVertex(bufferIn, matrix4f, matrix3f, 1, finalX, finalY, finalZ, textureUCoord, textureVCoord, color);
            }
        }
        bufferSource.m_109912_(RENDER_TYPE);
        pStack.m_85849_();
        RenderSystem.enableDepthTest();
    }

    private static void squareTexVertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, int uv2, float pX, float pY, float pZ, int pU, int pV, Color color) {
        vertexConsumer.m_252986_(matrix4f, pX, pY, pZ).m_7421_((float)pU, (float)pV).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), 127).m_86008_(OverlayTexture.f_118083_).m_85969_(uv2).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void drawBlocksAtPoint(PoseStack poseStack, Color color, List<BlockPos> blockPosList, float range, Vec3 highlightVector, ArrayList<BlockPos> targetedClusterBlockList) {
        poseStack.m_85836_();
        Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
        VertexConsumer bufferIn = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(CosmereAPIRenderTypes.BLOCK_OVERLAY.get());
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        for (BlockPos blockPos : blockPosList) {
            Color finalColor = color;
            if (highlightVector != null) {
                if (targetedClusterBlockList.contains(blockPos)) {
                    finalColor = Color.decode("#66b2ff");
                } else if (blockPos.m_252807_().equals((Object)highlightVector)) {
                    finalColor = Color.decode("#66b2ff");
                }
            }
            float alphaPercent = (float)Math.max(0.0, 1.0 - view.m_82554_(blockPos.m_252807_()) / (double)range);
            DrawHelper.renderColoredBlock(poseStack, bufferIn, finalColor, alphaPercent, blockPos);
        }
        Minecraft.m_91087_().m_91269_().m_110104_().m_109912_(CosmereAPIRenderTypes.BLOCK_OVERLAY.get());
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
    }

    protected static void renderColoredBlock(PoseStack poseStack, VertexConsumer builder, Color color, float alphaPercent, BlockPos pos) {
        DrawHelper.renderBoxSolid(poseStack, builder, pos, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.15f * alphaPercent);
    }

    protected static void renderBoxSolid(PoseStack poseStack, VertexConsumer builder, BlockPos pos, float r, float g, float b, float alpha) {
        double x = (double)pos.m_123341_() - 0.001;
        double y = (double)pos.m_123342_() - 0.001;
        double z = (double)pos.m_123343_() - 0.001;
        double xEnd = (double)pos.m_123341_() + 1.0015;
        double yEnd = (double)pos.m_123342_() + 1.0015;
        double zEnd = (double)pos.m_123343_() + 1.0015;
        DrawHelper.renderBoxSolid(poseStack, builder, x, y, z, xEnd, yEnd, zEnd, r, g, b, alpha);
    }

    protected static void renderBoxSolid(PoseStack poseStack, VertexConsumer builder, double x, double y, double z, double xEnd, double yEnd, double zEnd, float red, float green, float blue, float alpha) {
        float startX = (float)x;
        float startY = (float)y;
        float startZ = (float)z;
        float endX = (float)xEnd;
        float endY = (float)yEnd;
        float endZ = (float)zEnd;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        builder.m_252986_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static enum CosmereAPIRenderTypes {
        LINE_OVERLAY(() -> Internal.LINE_OVERLAY),
        BLOCK_OVERLAY(() -> Internal.BLOCK_OVERLAY);

        private final Supplier<RenderType> typeSupplier;

        private CosmereAPIRenderTypes(Supplier<RenderType> typeSupplier) {
            this.typeSupplier = typeSupplier;
        }

        public RenderType get() {
            return this.typeSupplier.get();
        }

        public static RenderType SQUARE_TEX_OVERLAY(ResourceLocation icon) {
            return Internal.SQUARE_OVERLAY.apply(icon, true);
        }

        private static class Internal
        extends RenderType {
            private static final RenderType LINE_OVERLAY = RenderType.m_173215_((String)"cosmere:lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(2.5))).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110125_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(RenderStateShard.f_110111_).m_110691_(false));
            private static final RenderType BLOCK_OVERLAY = Internal.m_173215_((String)"cosmere:block_render", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)25565, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173104_).m_173290_(f_110147_).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110125_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(RenderStateShard.f_110111_).m_110691_(false));
            private static final BiFunction<ResourceLocation, Boolean, RenderType> SQUARE_OVERLAY = Util.m_143821_((icon, createComposite) -> Internal.m_173215_((String)"cosmere:square_render", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)25565, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173102_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(icon, false, false)).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110125_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(RenderStateShard.f_110111_).m_110691_(createComposite.booleanValue())));

            private Internal(String name, VertexFormat fmt, VertexFormat.Mode glMode, int size, boolean doCrumbling, boolean depthSorting, Runnable onEnable, Runnable onDisable) {
                super(name, fmt, glMode, size, doCrumbling, depthSorting, onEnable, onDisable);
                throw new IllegalStateException("This class must not be instantiated");
            }
        }
    }
}

