/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api.helpers;

import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class RegistryHelper {
    private RegistryHelper() {
    }

    public static ResourceLocation get(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static ResourceLocation get(Entity entity) {
        return ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
    }

    public static ResourceLocation get(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public static ResourceLocation get(EntityType<?> test) {
        return ForgeRegistries.ENTITY_TYPES.getKey(test);
    }

    public static ResourceLocation getName(MenuType<?> element) {
        return RegistryHelper.getName(ForgeRegistries.MENU_TYPES, element);
    }

    public static ResourceLocation getName(ParticleType<?> element) {
        return RegistryHelper.getName(ForgeRegistries.PARTICLE_TYPES, element);
    }

    public static ResourceLocation getName(Item element) {
        return RegistryHelper.getName(ForgeRegistries.ITEMS, element);
    }

    public static String getPath(Item element) {
        return RegistryHelper.getName(element).m_135815_();
    }

    public static ResourceLocation getName(Block element) {
        return RegistryHelper.getName(ForgeRegistries.BLOCKS, element);
    }

    public static String getNamespace(Block element) {
        return RegistryHelper.getName(element).m_135827_();
    }

    public static String getPath(Block element) {
        return RegistryHelper.getName(element).m_135815_();
    }

    public static ResourceLocation getName(Fluid element) {
        return RegistryHelper.getName(ForgeRegistries.FLUIDS, element);
    }

    public static ResourceLocation getName(BlockEntityType<?> element) {
        return RegistryHelper.getName(ForgeRegistries.BLOCK_ENTITY_TYPES, element);
    }

    public static ResourceLocation getName(EntityType<?> element) {
        return RegistryHelper.getName(ForgeRegistries.ENTITY_TYPES, element);
    }

    public static ResourceLocation getName(RecipeSerializer<?> element) {
        return RegistryHelper.getName(ForgeRegistries.RECIPE_SERIALIZERS, element);
    }

    private static <T> ResourceLocation getName(IForgeRegistry<T> registry, T element) {
        return registry.getKey(element);
    }

    @Nullable
    public static ResourceLocation getNameGeneric(Object element) {
        for (Registry registry : BuiltInRegistries.f_257047_) {
            Optional resourceKey = registry.m_7854_(element);
            if (!resourceKey.isPresent()) continue;
            return ((ResourceKey)resourceKey.get()).m_135782_();
        }
        return null;
    }
}

