/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api.math;

import java.util.Random;
import net.minecraft.util.Mth;

public class MathHelper {
    public static final Random RANDOM = new Random();

    public static int randomInt(int min, int max) {
        return RANDOM.nextInt(max - min + 1) + min;
    }

    public static boolean chance(int chance) {
        return MathHelper.randomInt(1, chance) % chance == 0;
    }

    public static boolean randomBool() {
        return RANDOM.nextBoolean();
    }

    public static float InverseLerp(float a, float b, float value) {
        if (a != b) {
            return MathHelper.clamp01((value - a) / (b - a));
        }
        return 0.0f;
    }

    public static float clamp01(float f) {
        return Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
    }

    public static boolean inTriangle(double x1, double y1, double x2, double y2, double x3, double y3, double x, double y) {
        double ab = (x1 - x) * (y2 - y) - (x2 - x) * (y1 - y);
        double bc = (x2 - x) * (y3 - y) - (x3 - x) * (y2 - y);
        double ca = (x3 - x) * (y1 - y) - (x1 - x) * (y3 - y);
        return MathHelper.sign(ab) == MathHelper.sign(bc) && MathHelper.sign(bc) == MathHelper.sign(ca);
    }

    public static int sign(double n) {
        return n > 0.0 ? 1 : -1;
    }
}

