/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.client;

import com.mojang.blaze3d.platform.InputConstants;
import leaf.cosmere.api.Activator;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.client.Keybindings;
import leaf.cosmere.client.PowerSaveState;
import leaf.cosmere.common.Cosmere;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.fog.FogManager;
import leaf.cosmere.common.network.packets.ChangeManifestationModeMessage;
import leaf.cosmere.common.network.packets.ChangeSelectedManifestationMessage;
import leaf.cosmere.common.network.packets.DeactivateManifestationsMessage;
import leaf.cosmere.common.network.packets.SetSelectedManifestationMessage;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cosmere", value={Dist.CLIENT})
public class ClientForgeEvents {
    @SubscribeEvent
    public static void handleScroll(InputEvent.MouseScrollingEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        SpiritwebCapability.get((LivingEntity)player).ifPresent(spiritweb -> {
            if (held.m_41619_() && player.m_6047_() && event.isRightDown()) {
                int delta = Mth.m_14045_((int)((int)Math.round(event.getScrollDelta())), (int)-1, (int)1);
                Cosmere.packetHandler().sendToServer(new ChangeManifestationModeMessage(spiritweb.getSelectedManifestation(), delta));
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void onKey(InputEvent.Key event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        SpiritwebCapability.get((LivingEntity)player).ifPresent(spiritweb -> {
            Manifestation selected = spiritweb.getSelectedManifestation();
            if (ClientForgeEvents.isKeyPressed(event, Keybindings.MANIFESTATIONS_DEACTIVATE)) {
                Cosmere.packetHandler().sendToServer(new DeactivateManifestationsMessage());
            }
            if (ClientForgeEvents.isKeyPressed(event, Keybindings.MANIFESTATION_PREVIOUS)) {
                Cosmere.packetHandler().sendToServer(new ChangeSelectedManifestationMessage(-1));
            } else if (ClientForgeEvents.isKeyPressed(event, Keybindings.MANIFESTATION_NEXT)) {
                Cosmere.packetHandler().sendToServer(new ChangeSelectedManifestationMessage(1));
            }
            boolean modeIncreasePressed = ClientForgeEvents.isKeyPressed(event, Keybindings.MANIFESTATION_MODE_INCREASE);
            boolean modeDecreasedPressed = ClientForgeEvents.isKeyPressed(event, Keybindings.MANIFESTATION_MODE_DECREASE);
            if (modeIncreasePressed || modeDecreasedPressed) {
                int modifier = Screen.m_96638_() ? 5 : (Screen.m_96637_() ? 10 : 1);
                Cosmere.packetHandler().sendToServer(new ChangeManifestationModeMessage(selected, modeIncreasePressed ? modifier : -modifier));
            }
            for (Activator activator : Keybindings.activators) {
                if (!ClientForgeEvents.isKeyPressed(event, activator.getKeyMapping())) continue;
                Manifestation manifestation = activator.getManifestation();
                Cosmere.packetHandler().sendToServer(new SetSelectedManifestationMessage(manifestation));
                selected = manifestation;
                if (activator.getCategory().equals("sandmastery")) break;
                int modifier = -selected.getMode((ISpiritweb)spiritweb);
                if (!selected.isActive((ISpiritweb)spiritweb)) {
                    Cosmere.packetHandler().sendToServer(new ChangeManifestationModeMessage(selected, modifier += activator.getCategory().equals("feruchemy") ? -5 : 1));
                    spiritweb.getLiving().m_213846_((Component)Component.m_237113_((String)("Activated " + Component.m_237115_((String)selected.getTranslationKey()))));
                    continue;
                }
                Cosmere.packetHandler().sendToServer(new ChangeManifestationModeMessage(selected, modifier));
                spiritweb.getLiving().m_213846_((Component)Component.m_237113_((String)("Deactivated " + Component.m_237115_((String)selected.getTranslationKey()))));
            }
            if (!ClientForgeEvents.isKeyHeld(Keybindings.ACTIVATE_POWER_SAVE) && !ClientForgeEvents.isKeyHeld(Keybindings.SAVE_POWER_SAVE)) {
                return;
            }
            for (PowerSaveState.PowerSaves powerSave : PowerSaveState.PowerSaves.values()) {
                if (!ClientForgeEvents.isKeyPressed(event, Keybindings.getKey(powerSave.getNum()))) continue;
                if (ClientForgeEvents.isKeyHeld(Keybindings.ACTIVATE_POWER_SAVE)) {
                    powerSave.activate((ISpiritweb)spiritweb);
                    continue;
                }
                if (!ClientForgeEvents.isKeyHeld(Keybindings.SAVE_POWER_SAVE)) continue;
                powerSave.addManifestations((ISpiritweb)spiritweb);
            }
        });
    }

    private static boolean isKeyPressed(InputEvent.Key event, KeyMapping keyBinding) {
        return event.getKey() == keyBinding.getKey().m_84873_() && keyBinding.m_90859_();
    }

    private static boolean isKeyHeld(KeyMapping keyBinding) {
        InputConstants.Key key = keyBinding.getKey();
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.m_84873_());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderLevelLastEvent(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ProfilerFiller profiler = mc.m_91307_();
        LocalPlayer playerEntity = mc.f_91074_;
        profiler.m_6180_("cosmere-world-effects");
        SpiritwebCapability.get((LivingEntity)playerEntity).ifPresent(spiritweb -> spiritweb.renderWorldEffects(event));
        profiler.m_7238_();
    }

    @SubscribeEvent
    public static void onClientPlayerClone(ClientPlayerNetworkEvent.Clone event) {
        FogManager.resetFog();
    }
}

