/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.Cosmere;
import leaf.cosmere.common.network.packets.ChangeManifestationModeMessage;
import leaf.cosmere.common.registry.ManifestationRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PowerSaveState {
    private static @Nullable Map.Entry<Manifestation, Integer> getEntry(@NotNull Map<Manifestation, Integer> map, Manifestation manifestation) {
        for (Map.Entry<Manifestation, Integer> entry : map.entrySet()) {
            Manifestation entryType;
            Manifestation maniType = ManifestationRegistry.fromID(manifestation.getRegistryName());
            if (!maniType.equals(entryType = ManifestationRegistry.fromID(entry.getKey().getRegistryName()))) continue;
            return entry;
        }
        return null;
    }

    public static CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        for (PowerSaves saveState : PowerSaves.values()) {
            CompoundTag data = new CompoundTag();
            for (Manifestation manifest : saveState.manifestations.keySet()) {
                data.m_128405_(manifest.getRegistryName().toString(), saveState.manifestations.get(manifest).intValue());
            }
            nbt.m_128365_(Integer.toString(saveState.num), (Tag)data);
        }
        return nbt;
    }

    public static void deserialize(CompoundTag nbt) {
        for (PowerSaves state : PowerSaves.values()) {
            CompoundTag data = (CompoundTag)nbt.m_128423_(Integer.toString(state.num));
            HashMap<Manifestation, Integer> manifestations = new HashMap<Manifestation, Integer>();
            for (Manifestation manifestation : CosmereAPI.manifestationRegistry()) {
                String manifestationLoc = manifestation.getRegistryName().toString();
                if (!data.m_128441_(manifestationLoc)) continue;
                manifestations.put(manifestation, data.m_128451_(manifestationLoc));
            }
            state.setManifestations(manifestations);
        }
    }

    public static enum PowerSaves {
        POWER_SAVE_1(0),
        POWER_SAVE_2(1),
        POWER_SAVE_3(2),
        POWER_SAVE_4(3),
        POWER_SAVE_5(4),
        POWER_SAVE_6(5),
        POWER_SAVE_7(6),
        POWER_SAVE_8(7),
        POWER_SAVE_9(8);

        private HashMap<Manifestation, Integer> manifestations = new HashMap();
        private final int num;

        public static Optional<PowerSaves> valueOf(int value) {
            return Arrays.stream(PowerSaves.values()).filter(powerTypes -> powerTypes.num == value).findFirst();
        }

        private PowerSaves(int num) {
            this.num = num;
        }

        public String getName() {
            return "Power Save State " + (this.num + 1);
        }

        public int getNum() {
            return this.num;
        }

        public boolean isActive(ISpiritweb spiritweb) {
            HashMap<Manifestation, Integer> active = spiritweb.getManifestations();
            for (Map.Entry<Manifestation, Integer> entry : this.manifestations.entrySet()) {
                Map.Entry<Manifestation, Integer> activeEntry = PowerSaveState.getEntry(active, entry.getKey());
                if (activeEntry == null) {
                    return false;
                }
                if (entry.equals(activeEntry)) continue;
                return false;
            }
            return true;
        }

        public boolean hasManifestation(Manifestation manifestation) {
            return this.manifestations.containsKey(manifestation);
        }

        public void activate(ISpiritweb spiritweb) {
            boolean toActivate = !this.isActive(spiritweb);
            for (Manifestation manifestation : this.manifestations.keySet()) {
                int modifier = -manifestation.getMode(spiritweb);
                if (toActivate) {
                    modifier += this.manifestations.get(manifestation).intValue();
                }
                Cosmere.packetHandler().sendToServer(new ChangeManifestationModeMessage(manifestation, modifier));
            }
            if (toActivate) {
                spiritweb.getLiving().m_213846_((Component)Component.m_237113_((String)("Activating " + this.getName())));
            } else {
                spiritweb.getLiving().m_213846_((Component)Component.m_237113_((String)("Deactivating " + this.getName())));
            }
            this.manifestations.keySet().forEach(manifest -> spiritweb.getLiving().m_213846_((Component)Component.m_237113_((String)(Component.m_237115_((String)manifest.getTranslationKey()).getString() + ": " + manifest.getMode(spiritweb)))));
        }

        public void addManifestations(ISpiritweb spiritweb) {
            this.manifestations = spiritweb.getManifestations(false, true);
            spiritweb.getLiving().m_213846_((Component)Component.m_237113_((String)("Saved new " + this.getName())));
            this.manifestations.forEach((manifestation, integer) -> spiritweb.getLiving().m_213846_((Component)Component.m_237113_((String)(Component.m_237115_((String)manifestation.getTranslationKey()).getString() + ": " + integer))));
        }

        private void setManifestations(HashMap<Manifestation, Integer> manifestations) {
            this.manifestations = manifestations;
        }
    }
}

