/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.client.gui;

import com.google.common.base.Stopwatch;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import leaf.cosmere.api.IHasMetalType;
import leaf.cosmere.api.ISpiritwebSubmodule;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.math.MathHelper;
import leaf.cosmere.api.math.Vector2;
import leaf.cosmere.client.Keybindings;
import leaf.cosmere.client.gui.ButtonAction;
import leaf.cosmere.common.Cosmere;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.network.packets.ChangeManifestationModeMessage;
import leaf.cosmere.common.network.packets.SetSelectedManifestationMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SpiritwebMenu
extends Screen {
    final double TEXT_DISTANCE = 30.0;
    public static final SpiritwebMenu instance = new SpiritwebMenu();
    private SpiritwebCapability spiritweb = null;
    private float visibility = 0.0f;
    private Stopwatch lastChange = Stopwatch.createStarted();
    public Manifestation selectedManifestation = null;
    public SidedMenuButton doAction = null;
    private Manifestations.ManifestationTypes selectedPowerType = Manifestations.ManifestationTypes.ALLOMANCY;
    protected ArrayList<RadialMenuButton> radialMenuButtons = new ArrayList();
    protected ArrayList<SidedMenuButton> sidedMenuButtons = new ArrayList();
    protected ArrayList<MetalQuadrant> metalQuadrants = new ArrayList();
    private final List<String> m_infoText = new ArrayList<String>();

    protected SpiritwebMenu() {
        super((Component)Component.m_237113_((String)"Menu"));
        this.f_96541_ = this.getMinecraft();
    }

    public boolean m_7043_() {
        return false;
    }

    public void raiseVisibility() {
        float TIME_SCALE = 0.01f;
        this.visibility = MathHelper.clamp01(this.visibility + (float)this.lastChange.elapsed(TimeUnit.MILLISECONDS) * 0.01f);
        this.lastChange = Stopwatch.createStarted();
    }

    public void setScaledResolution(int scaledWidth, int scaledHeight) {
        this.f_96543_ = scaledWidth;
        this.f_96544_ = scaledHeight;
    }

    public Minecraft getMinecraft() {
        return Minecraft.m_91087_();
    }

    public void postRender(SpiritwebCapability spiritweb) {
        if (Keybindings.MANIFESTATION_MENU.m_90859_()) {
            Window window = this.f_96541_.m_91268_();
            this.m_6575_(this.f_96541_, window.m_85445_(), window.m_85446_());
            this.setScaledResolution(window.m_85445_(), window.m_85446_());
            this.spiritweb = spiritweb;
            this.f_96541_.m_91152_((Screen)instance);
            this.visibility = 0.0f;
            this.lastChange = Stopwatch.createStarted();
            this.selectedManifestation = spiritweb.getSelectedManifestation();
            this.SetupButtons();
        }
        if (this.f_96541_.f_91080_ == instance) {
            this.raiseVisibility();
        }
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        if (Keybindings.MANIFESTATION_MENU.m_90832_(pKeyCode, pScanCode)) {
            for (RadialMenuButton radialMenuButton : this.radialMenuButtons) {
                if (!radialMenuButton.highlighted) continue;
                Cosmere.packetHandler().sendToServer(new SetSelectedManifestationMessage(radialMenuButton.manifestation));
                break;
            }
            this.CloseScreen();
        }
        return super.m_7920_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (RadialMenuButton radialMenuButton : this.radialMenuButtons) {
            if (!radialMenuButton.highlighted) continue;
            if (button == 0) {
                Cosmere.packetHandler().sendToServer(new ChangeManifestationModeMessage(radialMenuButton.manifestation, 1));
            } else {
                Cosmere.packetHandler().sendToServer(new ChangeManifestationModeMessage(radialMenuButton.manifestation, -1));
            }
            return true;
        }
        for (SidedMenuButton sidedMenuButton : this.sidedMenuButtons) {
            if (!sidedMenuButton.highlighted) continue;
            if (sidedMenuButton.powerType != -1) {
                this.selectedPowerType = Manifestations.ManifestationTypes.valueOf(this.doAction.powerType).get();
                this.SetupButtons();
            } else if (sidedMenuButton.action != null) {
                // empty if block
            }
            return true;
        }
        return true;
    }

    private void CloseScreen() {
        this.f_96541_.m_91152_(null);
    }

    protected void SetupButtons() {
        List<Manifestation> availableManifestations;
        this.radialMenuButtons.clear();
        this.sidedMenuButtons.clear();
        this.metalQuadrants.clear();
        if (this.selectedPowerType == Manifestations.ManifestationTypes.ALLOMANCY || this.selectedPowerType == Manifestations.ManifestationTypes.FERUCHEMY) {
            double quadCenterX = (double)((float)this.f_96543_ / 2.0f) - MetalQuadrant.width * 3.0;
            double quadCenterY = (double)((float)this.f_96544_ / 2.0f) - MetalQuadrant.height * 0.75;
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.IRON, quadCenterX - MetalQuadrant.width / 2.0, quadCenterY - MetalQuadrant.height / 2.0));
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.STEEL, quadCenterX + 2.0 + MetalQuadrant.width / 2.0, quadCenterY - MetalQuadrant.height / 2.0));
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.TIN, quadCenterX - MetalQuadrant.width / 2.0, quadCenterY + 2.0 + MetalQuadrant.height / 2.0));
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.PEWTER, quadCenterX + 2.0 + MetalQuadrant.width / 2.0, quadCenterY + 2.0 + MetalQuadrant.height / 2.0));
            quadCenterX = (double)(this.f_96543_ / 2) + MetalQuadrant.width * 3.0;
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.ZINC, quadCenterX - MetalQuadrant.width / 2.0, quadCenterY - MetalQuadrant.height / 2.0));
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.BRASS, quadCenterX + 2.0 + MetalQuadrant.width / 2.0, quadCenterY - MetalQuadrant.height / 2.0));
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.COPPER, quadCenterX - MetalQuadrant.width / 2.0, quadCenterY + 2.0 + MetalQuadrant.height / 2.0));
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.BRONZE, quadCenterX + 2.0 + MetalQuadrant.width / 2.0, quadCenterY + 2.0 + MetalQuadrant.height / 2.0));
            quadCenterX = (double)((float)this.f_96543_ / 2.0f) - MetalQuadrant.width * 3.0;
            quadCenterY = (double)((float)this.f_96544_ / 2.0f) + MetalQuadrant.height * 1.75;
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.ALUMINUM, quadCenterX - MetalQuadrant.width / 2.0, quadCenterY - MetalQuadrant.height / 2.0));
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.DURALUMIN, quadCenterX + 2.0 + MetalQuadrant.width / 2.0, quadCenterY - MetalQuadrant.height / 2.0));
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.CHROMIUM, quadCenterX - MetalQuadrant.width / 2.0, quadCenterY + 2.0 + MetalQuadrant.height / 2.0));
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.NICROSIL, quadCenterX + 2.0 + MetalQuadrant.width / 2.0, quadCenterY + 2.0 + MetalQuadrant.height / 2.0));
            quadCenterX = (double)(this.f_96543_ / 2) + MetalQuadrant.width * 3.0;
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.GOLD, quadCenterX - MetalQuadrant.width / 2.0, quadCenterY - MetalQuadrant.height / 2.0));
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.ELECTRUM, quadCenterX + 2.0 + MetalQuadrant.width / 2.0, quadCenterY - MetalQuadrant.height / 2.0));
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.CADMIUM, quadCenterX - MetalQuadrant.width / 2.0, quadCenterY + 2.0 + MetalQuadrant.height / 2.0));
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.BENDALLOY, quadCenterX + 2.0 + MetalQuadrant.width / 2.0, quadCenterY + 2.0 + MetalQuadrant.height / 2.0));
            this.metalQuadrants.add(new MetalQuadrant(Metals.MetalType.ATIUM, (double)this.f_96543_ / 2.0, quadCenterY + MetalQuadrant.height / 2.0));
        }
        if ((availableManifestations = this.spiritweb.getAvailableManifestations()).size() <= 16) {
            for (Manifestation manifestation : availableManifestations) {
                this.radialMenuButtons.add(new RadialMenuButton(manifestation));
            }
        } else {
            HashSet<Manifestations.ManifestationTypes> foundPowerTypes = new HashSet<Manifestations.ManifestationTypes>();
            for (Manifestation manifestation : availableManifestations) {
                if (manifestation.getManifestationType() == this.selectedPowerType) {
                    this.radialMenuButtons.add(new RadialMenuButton(manifestation));
                }
                foundPowerTypes.add(manifestation.getManifestationType());
            }
            for (Manifestations.ManifestationTypes foundPowerType : foundPowerTypes) {
                int index = foundPowerType.getID() - 1;
                double v = 30.0 * (double)index;
                this.sidedMenuButtons.add(new SidedMenuButton(foundPowerType.getName(), foundPowerType.getID(), v - 30.0 * (double)foundPowerTypes.size() / 2.0 + 5.0, -90.0, Direction.UP));
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = guiGraphics.m_280168_();
        if (this.spiritweb == null) {
            return;
        }
        matrixStack.m_85836_();
        int start = (int)(this.visibility * 98.0f) << 24;
        int end = (int)(this.visibility * 128.0f) << 24;
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, start, end);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        double mouseVecX = (float)mouseX - (float)this.f_96543_ / 2.0f;
        double mouseVecY = (float)mouseY - (float)this.f_96544_ / 2.0f;
        double middle_x = (float)this.f_96543_ / 2.0f;
        double middle_y = (float)this.f_96544_ / 2.0f;
        this.selectedManifestation = null;
        this.doAction = null;
        this.renderRadialButtons(buffer, mouseVecX, mouseVecY, middle_x, middle_y);
        this.renderSidedButtons(buffer, mouseVecX, mouseVecY, middle_x, middle_y);
        this.renderMetalQuadrants(buffer);
        tessellator.m_85914_();
        this.drawIcons(guiGraphics, buffer, middle_x, middle_y);
        this.renderRadialButtonStrings(guiGraphics, (int)middle_x, (int)middle_y);
        this.renderSidedButtonStrings(guiGraphics, middle_x, middle_y);
        this.renderMetalQuadrantsStrings(guiGraphics);
        this.renderAnyExtraInfoTexts(guiGraphics, (int)middle_x, (int)middle_y);
        matrixStack.m_85849_();
    }

    private void drawIcons(@NotNull GuiGraphics guiGraphics, BufferBuilder buffer, double middle_x, double middle_y) {
        PoseStack matrixStack = guiGraphics.m_280168_();
        matrixStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::m_172817_);
        this.renderRadialButtonIcons(guiGraphics, middle_x, middle_y);
        this.renderSidedButtonIcons(guiGraphics, middle_x, middle_y);
        matrixStack.m_85849_();
    }

    private void renderAnyExtraInfoTexts(GuiGraphics guiGraphics, int middle_x, int middle_y) {
        int leftSideX = 10;
        int[] y = new int[]{middle_y / 2};
        if (this.selectedPowerType == Manifestations.ManifestationTypes.SANDMASTERY) {
            this.m_infoText.clear();
            for (ISpiritwebSubmodule spiritwebSubmodule : this.spiritweb.getSubmodules().values()) {
                spiritwebSubmodule.collectMenuInfo(this.m_infoText);
            }
            for (String s : this.m_infoText) {
                if (!s.toLowerCase().contains("hydration")) continue;
                guiGraphics.m_280488_(this.f_96547_, s, leftSideX, y[0], -1);
                y[0] = y[0] + 10;
            }
        }
        if (this.selectedManifestation == null) {
            return;
        }
        y[0] = middle_y / 2;
        int rightSideX = middle_x + 35;
        guiGraphics.m_280488_(this.f_96547_, I18n.m_118938_((String)this.selectedManifestation.getTranslationKey(), (Object[])new Object[0]), rightSideX, y[0], -1);
        guiGraphics.m_280488_(this.f_96547_, "Mode: " + this.spiritweb.getMode(this.selectedManifestation), rightSideX, y[0] + 10, -1);
    }

    private void renderMetalQuadrantsStrings(GuiGraphics guiGraphics) {
        PoseStack matrixStack = guiGraphics.m_280168_();
        this.m_infoText.clear();
        List<Manifestation> maniList = this.spiritweb.getAvailableManifestations();
        int maniListSize = maniList.size();
        boolean manifestationNotNull = this.selectedManifestation != null;
        boolean inMetalSubmenu = (this.selectedPowerType == Manifestations.ManifestationTypes.ALLOMANCY || this.selectedPowerType == Manifestations.ManifestationTypes.FERUCHEMY) && maniListSize > 16;
        boolean shouldShowAllomancy = maniListSize <= 16 && manifestationNotNull && this.selectedManifestation.getManifestationType() == Manifestations.ManifestationTypes.ALLOMANCY;
        boolean shouldShowFeruchemy = maniListSize <= 16 && manifestationNotNull && this.selectedManifestation.getManifestationType() == Manifestations.ManifestationTypes.FERUCHEMY;
        boolean manifestationIsSelected = shouldShowAllomancy || shouldShowFeruchemy;
        for (ISpiritwebSubmodule submodule : this.spiritweb.getSubmodules().values()) {
            submodule.collectMenuInfo(this.m_infoText);
        }
        for (MetalQuadrant quad : this.metalQuadrants) {
            boolean selectedFeruchemyType;
            boolean foundNumber = false;
            boolean selectedAllomancyType = this.selectedPowerType == Manifestations.ManifestationTypes.ALLOMANCY || shouldShowAllomancy;
            boolean bl = selectedFeruchemyType = this.selectedPowerType == Manifestations.ManifestationTypes.FERUCHEMY || shouldShowFeruchemy;
            if (inMetalSubmenu || manifestationIsSelected) {
                for (String s : this.m_infoText) {
                    if ((inMetalSubmenu && selectedAllomancyType || shouldShowAllomancy) && s.toLowerCase().contains("a. " + quad.metalType.m_6082_()) && maniList.contains(Manifestations.ManifestationTypes.ALLOMANCY.getManifestation(quad.metalType.getID()))) {
                        Object displayString = s.split(":")[1].stripLeading();
                        int n = (int)(quad.centerX - (double)((float)this.f_96547_.m_92895_((String)displayString) / 2.0f));
                        int n2 = (int)quad.centerY;
                        Objects.requireNonNull(this.f_96547_);
                        guiGraphics.m_280488_(this.f_96547_, (String)displayString, n, n2 + 9, -1);
                        displayString = quad.metalType.m_6082_().substring(0, 1).toUpperCase() + quad.metalType.m_6082_().substring(1);
                        int n3 = (int)(quad.centerX - (double)((float)this.f_96547_.m_92895_((String)displayString) / 2.0f));
                        double d = quad.centerY;
                        Objects.requireNonNull(this.f_96547_);
                        guiGraphics.m_280488_(this.f_96547_, (String)displayString, n3, (int)(d - (double)(9.0f * 1.5f)), -1);
                        foundNumber = true;
                        break;
                    }
                    if ((!inMetalSubmenu || !selectedFeruchemyType) && !shouldShowFeruchemy || !s.toLowerCase().contains("f. " + quad.metalType.m_6082_()) || !maniList.contains(Manifestations.ManifestationTypes.FERUCHEMY.getManifestation(quad.metalType.getID()))) continue;
                    Object displayString = s.split(":")[1].stripLeading();
                    int n = (int)(quad.centerX - (double)((float)this.f_96547_.m_92895_((String)displayString) / 2.0f));
                    int n4 = (int)quad.centerY;
                    Objects.requireNonNull(this.f_96547_);
                    guiGraphics.m_280488_(this.f_96547_, (String)displayString, n, n4 + 9, -1);
                    displayString = quad.metalType.m_6082_().substring(0, 1).toUpperCase() + quad.metalType.m_6082_().substring(1);
                    int n5 = (int)(quad.centerX - (double)((float)this.f_96547_.m_92895_((String)displayString) / 2.0f));
                    double d = quad.centerY;
                    Objects.requireNonNull(this.f_96547_);
                    guiGraphics.m_280488_(this.f_96547_, (String)displayString, n5, (int)(d - (double)(9.0f * 1.5f)), -1);
                    foundNumber = true;
                    break;
                }
            }
            boolean alloManiListContains = maniList.contains(Manifestations.ManifestationTypes.ALLOMANCY.getManifestation(quad.metalType.getID()));
            boolean feruManiListContains = maniList.contains(Manifestations.ManifestationTypes.FERUCHEMY.getManifestation(quad.metalType.getID()));
            boolean shouldDrawMetalNames = !foundNumber && (inMetalSubmenu && (selectedAllomancyType && alloManiListContains || selectedFeruchemyType && feruManiListContains) || !inMetalSubmenu && (shouldShowAllomancy && alloManiListContains || shouldShowFeruchemy && feruManiListContains));
            if (!shouldDrawMetalNames) continue;
            Object displayString = "0";
            int n = (int)(quad.centerX - (double)((float)this.f_96547_.m_92895_((String)displayString) / 2.0f));
            double d = quad.centerY;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280488_(this.f_96547_, (String)displayString, n, (int)(d + 9.0), -1);
            displayString = quad.metalType.m_6082_().substring(0, 1).toUpperCase() + quad.metalType.m_6082_().substring(1);
            int n6 = (int)(quad.centerX - (double)((float)this.f_96547_.m_92895_((String)displayString) / 2.0f));
            double d2 = quad.centerY;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280488_(this.f_96547_, (String)displayString, n6, (int)(d2 - (double)(9.0f * 1.5f)), -1);
        }
    }

    private void renderSidedButtonStrings(GuiGraphics guiGraphics, double middle_x, double middle_y) {
        for (SidedMenuButton sideButton : this.sidedMenuButtons) {
            if (!sideButton.highlighted) continue;
            String text = I18n.m_118938_((String)sideButton.name, (Object[])new Object[0]);
            switch (sideButton.textSide) {
                case WEST: {
                    guiGraphics.m_280488_(this.f_96547_, text, (int)(middle_x + sideButton.x1 - 8.0) - this.f_96547_.m_92895_(text), (int)(middle_y + sideButton.y1 + 6.0), -1);
                    break;
                }
                case EAST: {
                    guiGraphics.m_280488_(this.f_96547_, text, (int)(middle_x + sideButton.x2 + 8.0), (int)(middle_y + sideButton.y1 + 6.0), -1);
                    break;
                }
                case UP: {
                    guiGraphics.m_280488_(this.f_96547_, text, (int)(middle_x + (sideButton.x1 + sideButton.x2) * 0.5 - (double)this.f_96547_.m_92895_(text) * 0.5), (int)(middle_y + sideButton.y1 - 14.0), -1);
                    break;
                }
                case DOWN: {
                    guiGraphics.m_280488_(this.f_96547_, text, (int)(middle_x + (sideButton.x1 + sideButton.x2) * 0.5 - (double)this.f_96547_.m_92895_(text) * 0.5), (int)(middle_y + sideButton.y1 + 24.0), -1);
                }
            }
        }
    }

    private void renderRadialButtonStrings(GuiGraphics guiGraphics, int middle_x, int middle_y) {
        for (RadialMenuButton button : this.radialMenuButtons) {
            if (!button.highlighted) continue;
            double x = button.centerX;
            double y = button.centerY;
            int fixed_x = (int)x;
            int fixed_y = (int)y;
            String text = I18n.m_118938_((String)button.manifestation.getTranslationKey(), (Object[])new Object[0]);
            fixed_x = (int)(x < 0.0 ? (double)fixed_x - ((double)this.f_96547_.m_92895_(text) + 30.0) : (double)fixed_x + 30.0);
            guiGraphics.m_280488_(this.f_96547_, text, middle_x + fixed_x, middle_y + fixed_y, -1);
            break;
        }
    }

    private void renderSidedButtonIcons(GuiGraphics guiGraphics, double middleX, double middleY) {
        StringBuilder stringBuilder = new StringBuilder();
        for (SidedMenuButton button : this.sidedMenuButtons) {
            stringBuilder.setLength(0);
            double x = (button.x1 + button.x2) / 2.0 + 0.01;
            double y = (button.y1 + button.y2) / 2.0 + 0.01;
            stringBuilder.append("textures/icon/").append(button.name).append(".png");
            guiGraphics.m_280411_(new ResourceLocation(button.name, stringBuilder.toString()), (int)(middleX + x - 8.0), (int)(middleY + y - 8.0), 16, 16, 0.0f, 0.0f, 18, 18, 18, 18);
        }
    }

    private void renderRadialButtonIcons(GuiGraphics guiGraphics, double middleX, double middleY) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RadialMenuButton menuRegion : this.radialMenuButtons) {
            stringBuilder.setLength(0);
            double x = menuRegion.centerX;
            double y = menuRegion.centerY;
            double scalex = 7.5;
            double scaley = 7.5;
            double x1 = x - 7.5;
            double y1 = y - 7.5;
            Manifestation mani = menuRegion.manifestation;
            Manifestations.ManifestationTypes manifestationType = mani.getManifestationType();
            String manifestationTypeName = manifestationType.getName();
            stringBuilder.append("textures/icon/").append(manifestationTypeName).append("/");
            switch (manifestationType) {
                case ALLOMANCY: 
                case FERUCHEMY: {
                    if (!(mani instanceof IHasMetalType)) break;
                    IHasMetalType metalType = (IHasMetalType)((Object)mani);
                    stringBuilder.append(metalType.getMetalType().m_6082_());
                    break;
                }
                case SURGEBINDING: {
                    stringBuilder.append(mani.getName());
                    break;
                }
                case AON_DOR: {
                    break;
                }
            }
            stringBuilder.append(".png");
            ResourceLocation textureLocation = new ResourceLocation(mani.getRegistryName().m_135827_(), stringBuilder.toString());
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
            guiGraphics.m_280411_(textureLocation, (int)(middleX + x1), (int)(middleY + y1), 16, 16, 0.0f, 0.0f, 18, 18, 18, 18);
        }
    }

    private void renderSidedButtons(BufferBuilder buffer, double mouseVecX, double mouseVecY, double middle_x, double middle_y) {
        for (SidedMenuButton button : this.sidedMenuButtons) {
            float f;
            float a = 0.5f;
            if (button.x1 <= mouseVecX && button.x2 >= mouseVecX && button.y1 <= mouseVecY && button.y2 >= mouseVecY) {
                f = 1.0f;
                button.highlighted = true;
                this.doAction = button;
            } else {
                button.highlighted = false;
                f = this.selectedPowerType.getID() == button.powerType ? 1.0f : 0.0f;
            }
            buffer.m_5483_(middle_x + button.x1, middle_y + button.y1, 0.0).m_85950_(f, f, f, 0.5f).m_5752_();
            buffer.m_5483_(middle_x + button.x1, middle_y + button.y2, 0.0).m_85950_(f, f, f, 0.5f).m_5752_();
            buffer.m_5483_(middle_x + button.x2, middle_y + button.y2, 0.0).m_85950_(f, f, f, 0.5f).m_5752_();
            buffer.m_5483_(middle_x + button.x2, middle_y + button.y1, 0.0).m_85950_(f, f, f, 0.5f).m_5752_();
        }
    }

    private void renderMetalQuadrants(BufferBuilder buffer) {
        List<Manifestation> maniList = this.spiritweb.getAvailableManifestations();
        boolean manifestationIsSelected = this.selectedManifestation != null && maniList.size() <= 16 && (this.selectedManifestation.getManifestationType() == Manifestations.ManifestationTypes.ALLOMANCY || this.selectedManifestation.getManifestationType() == Manifestations.ManifestationTypes.FERUCHEMY);
        boolean allomancySubmenuOpen = this.selectedPowerType == Manifestations.ManifestationTypes.ALLOMANCY && maniList.size() > 16;
        boolean feruchemySubmenuOpen = this.selectedPowerType == Manifestations.ManifestationTypes.FERUCHEMY && maniList.size() > 16;
        boolean hasSubmenu = allomancySubmenuOpen || feruchemySubmenuOpen;
        boolean allomancySelected = !hasSubmenu && manifestationIsSelected && this.selectedManifestation.getManifestationType() == Manifestations.ManifestationTypes.ALLOMANCY;
        boolean feruchemySelected = !hasSubmenu && manifestationIsSelected && this.selectedManifestation.getManifestationType() == Manifestations.ManifestationTypes.FERUCHEMY;
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 127;
        for (MetalQuadrant quadrant : this.metalQuadrants) {
            Manifestation alloMani = Manifestations.ManifestationTypes.ALLOMANCY.getManifestation(quadrant.metalType.getID());
            Manifestation feruMani = Manifestations.ManifestationTypes.FERUCHEMY.getManifestation(quadrant.metalType.getID());
            if (!(hasSubmenu && (allomancySubmenuOpen && maniList.contains(alloMani) || feruchemySubmenuOpen && maniList.contains(feruMani))) && (hasSubmenu || (!allomancySelected || !maniList.contains(alloMani)) && (!feruchemySelected || !maniList.contains(feruMani)))) continue;
            buffer.m_5483_(quadrant.centerX - MetalQuadrant.width / 2.0, quadrant.centerY - MetalQuadrant.height / 2.0, 0.0).m_6122_(r, g, b, a).m_5752_();
            buffer.m_5483_(quadrant.centerX - MetalQuadrant.width / 2.0, quadrant.centerY + MetalQuadrant.height / 2.0, 0.0).m_6122_(r, g, b, a).m_5752_();
            buffer.m_5483_(quadrant.centerX + MetalQuadrant.width / 2.0, quadrant.centerY + MetalQuadrant.height / 2.0, 0.0).m_6122_(r, g, b, a).m_5752_();
            buffer.m_5483_(quadrant.centerX + MetalQuadrant.width / 2.0, quadrant.centerY - MetalQuadrant.height / 2.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        }
    }

    private void renderRadialButtons(BufferBuilder buffer, double mouseVecX, double mouseVecY, double middle_x, double middle_y) {
        if (!this.radialMenuButtons.isEmpty()) {
            float ring_inner_edge = -20.0f;
            float ring_outer_edge = -60.0f;
            int totalButtons = this.radialMenuButtons.size();
            int drawMode = this.radialMenuButtons.size();
            Vector2 innerEdge = new Vector2(0.0f, -20.0f);
            Vector2 outerEdge = new Vector2(0.0f, -60.0f);
            for (int i = this.radialMenuButtons.size() - 1; i >= 0; --i) {
                boolean showHighlight;
                double y1m2;
                double x1m2;
                double y2m1;
                double x2m1;
                double y1m1;
                double x1m1;
                RadialMenuButton region = this.radialMenuButtons.get(i);
                if (drawMode == 1) {
                    x1m1 = outerEdge.x;
                    y1m1 = outerEdge.y;
                    outerEdge.Rotate(90.0f);
                    x2m1 = outerEdge.x;
                    y2m1 = outerEdge.y;
                    outerEdge.Rotate(90.0f);
                    x1m2 = outerEdge.x;
                    y1m2 = outerEdge.y;
                    outerEdge.Rotate(90.0f);
                } else if (drawMode == 2) {
                    x1m1 = outerEdge.x;
                    y1m1 = outerEdge.y;
                    outerEdge.Rotate(60.0f);
                    x2m1 = outerEdge.x;
                    y2m1 = outerEdge.y;
                    outerEdge.Rotate(60.0f);
                    x1m2 = outerEdge.x;
                    y1m2 = outerEdge.y;
                    outerEdge.Rotate(60.0f);
                } else {
                    x1m1 = innerEdge.x;
                    y1m1 = innerEdge.y;
                    x2m1 = outerEdge.x;
                    y2m1 = outerEdge.y;
                    innerEdge.Rotate(-(360.0f / (float)totalButtons));
                    outerEdge.Rotate(-(360.0f / (float)totalButtons));
                    x1m2 = innerEdge.x;
                    y1m2 = innerEdge.y;
                }
                double x2m2 = outerEdge.x;
                double y2m2 = outerEdge.y;
                region.centerX = (x1m1 + x2m1 + x1m2 + x2m2) / 4.0;
                region.centerY = (y1m1 + y2m1 + y1m2 + y2m2) / 4.0;
                float a = 0.5f;
                float f = 0.0f;
                if (drawMode <= 2) {
                    showHighlight = MathHelper.inTriangle(x1m1, y1m1, x2m1, y2m1, x1m2, y1m2, mouseVecX, mouseVecY) || MathHelper.inTriangle(x1m2, y1m2, x2m2, y2m2, x1m1, y1m1, mouseVecX, mouseVecY);
                } else {
                    boolean bl = showHighlight = MathHelper.inTriangle(x1m1, y1m1, x2m2, y2m2, x2m1, y2m1, mouseVecX, mouseVecY) || MathHelper.inTriangle(x1m1, y1m1, x1m2, y1m2, x2m2, y2m2, mouseVecX, mouseVecY);
                }
                if (showHighlight) {
                    f = 0.1f;
                    region.highlighted = true;
                    this.selectedManifestation = region.manifestation;
                } else {
                    region.highlighted = false;
                }
                float lerpPositive = 0.0f;
                float lerpNegative = 0.0f;
                if (region.manifestation != null) {
                    int mode = region.manifestation.getMode(this.spiritweb);
                    int modeMin = region.manifestation.modeMin(this.spiritweb);
                    int modeMax = region.manifestation.modeMax(this.spiritweb);
                    if (mode > 0) {
                        lerpPositive = MathHelper.InverseLerp(0.0f, modeMax, mode) - 0.1f;
                    } else if (mode < 0) {
                        lerpNegative = MathHelper.InverseLerp(0.0f, Math.abs(modeMin), Math.abs(mode)) - 0.1f;
                    }
                }
                float r = lerpPositive + f;
                float g = f;
                float b = lerpNegative + f;
                if (drawMode <= 2) {
                    buffer.m_5483_(middle_x + x2m1, middle_y + y2m1, 0.0).m_85950_(r, g, b, 0.5f).m_5752_();
                    buffer.m_5483_(middle_x + x1m1, middle_y + y1m1, 0.0).m_85950_(r, g, b, 0.5f).m_5752_();
                } else {
                    buffer.m_5483_(middle_x + x1m1, middle_y + y1m1, 0.0).m_85950_(r, g, b, 0.5f).m_5752_();
                    buffer.m_5483_(middle_x + x2m1, middle_y + y2m1, 0.0).m_85950_(r, g, b, 0.5f).m_5752_();
                }
                buffer.m_5483_(middle_x + x2m2, middle_y + y2m2, 0.0).m_85950_(r, g, b, 0.5f).m_5752_();
                buffer.m_5483_(middle_x + x1m2, middle_y + y1m2, 0.0).m_85950_(r, g, b, 0.5f).m_5752_();
            }
        }
    }

    private static class SidedMenuButton {
        public double x1;
        public double x2;
        public double y1;
        public double y2;
        public boolean highlighted;
        public final ButtonAction action;
        public final int powerType;
        public int color;
        public String name;
        public Direction textSide;

        public SidedMenuButton(String name, ButtonAction action, double x, double y, Direction textSide) {
            this.name = name;
            this.action = action;
            this.powerType = -1;
            this.x1 = x;
            this.x2 = x + 18.0;
            this.y1 = y;
            this.y2 = y + 18.0;
            this.color = 0xFFFFFF;
            this.textSide = textSide;
        }

        public SidedMenuButton(String name, int powerType, double x, double y, Direction textSide) {
            this.name = name;
            this.action = null;
            this.powerType = powerType;
            this.x1 = x;
            this.x2 = x + 18.0;
            this.y1 = y;
            this.y2 = y + 18.0;
            this.color = 0xFFFFFF;
            this.textSide = textSide;
        }
    }

    static class RadialMenuButton {
        public final Manifestation manifestation;
        public double centerX;
        public double centerY;
        public boolean highlighted;

        public RadialMenuButton(Manifestation manifestation) {
            this.manifestation = manifestation;
        }
    }

    static class MetalQuadrant {
        public final Metals.MetalType metalType;
        public double centerX;
        public double centerY;
        public static double width = 50.0;
        public static double height = 40.0;

        public MetalQuadrant(Metals.MetalType metalType, double centerX, double centerY) {
            this.metalType = metalType;
            this.centerX = centerX;
            this.centerY = centerY;
        }
    }
}

