/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common;

import java.util.HashMap;
import java.util.Map;
import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.IModModule;
import leaf.cosmere.api.ISpiritwebSubmodule;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Version;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.compat.curios.CuriosCompat;
import leaf.cosmere.common.compat.patchouli.PatchouliCompat;
import leaf.cosmere.common.config.CosmereConfigs;
import leaf.cosmere.common.config.CosmereModConfig;
import leaf.cosmere.common.eventHandlers.ColorHandler;
import leaf.cosmere.common.network.NetworkPacketHandler;
import leaf.cosmere.common.registry.AdvancementTriggerRegistry;
import leaf.cosmere.common.registry.ArgumentTypeRegistry;
import leaf.cosmere.common.registry.AttributesRegistry;
import leaf.cosmere.common.registry.BiomeModifierRegistry;
import leaf.cosmere.common.registry.BiomeRegistry;
import leaf.cosmere.common.registry.BlocksRegistry;
import leaf.cosmere.common.registry.CosmereEffectsRegistry;
import leaf.cosmere.common.registry.CreativeTabsRegistry;
import leaf.cosmere.common.registry.DimensionRegistry;
import leaf.cosmere.common.registry.EntityTypeRegistry;
import leaf.cosmere.common.registry.FeatureRegistry;
import leaf.cosmere.common.registry.GameEventRegistry;
import leaf.cosmere.common.registry.HeightProviderTypesRegistry;
import leaf.cosmere.common.registry.IntProviderTypesRegistry;
import leaf.cosmere.common.registry.ItemsRegistry;
import leaf.cosmere.common.registry.LootFunctionRegistry;
import leaf.cosmere.common.registry.LootModifiersRegistry;
import leaf.cosmere.common.registry.ManifestationRegistry;
import leaf.cosmere.common.registry.PoiTypesRegistry;
import leaf.cosmere.common.registry.VillagerProfessionRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="cosmere")
public class Cosmere {
    public static final String MODID = "cosmere";
    public static final Map<String, IModModule> modulesLoaded = new HashMap<String, IModModule>();
    public static Cosmere instance;
    public final Version versionNumber;
    private final NetworkPacketHandler packetHandler;

    public Cosmere() {
        instance = this;
        CosmereConfigs.registerConfigs(ModLoadingContext.get());
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::onCommonSetup);
        modBus.addListener(this::onClientSetup);
        modBus.addListener(this::onAddCaps);
        modBus.addListener(this::onConfigLoad);
        modBus.addListener(this::onConfigReload);
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer());
        ItemsRegistry.ITEMS.register(modBus);
        BlocksRegistry.BLOCKS.register(modBus);
        EntityTypeRegistry.ENTITY_TYPES.register(modBus);
        AttributesRegistry.ATTRIBUTES.register(modBus);
        ManifestationRegistry.MANIFESTATIONS.createAndRegisterManifestation(modBus);
        CosmereEffectsRegistry.EFFECTS.createAndRegister(modBus);
        PoiTypesRegistry.POINT_OF_INTERESTS.register(modBus);
        VillagerProfessionRegistry.VILLAGE_PROFESSIONS.register(modBus);
        BiomeModifierRegistry.BIOME_MODIFIER_SERIALIZERS.register(modBus);
        LootFunctionRegistry.LOOT_FUNCTIONS.register(modBus);
        GameEventRegistry.GAME_EVENTS.register(modBus);
        ArgumentTypeRegistry.ARGUMENT_TYPE_INFOS.register(modBus);
        CreativeTabsRegistry.CREATIVE_TABS.register(modBus);
        BiomeRegistry.BIOMES.register(modBus);
        LootModifiersRegistry.LOOT_MODIFIERS.register(modBus);
        FeatureRegistry.FEATURES.register(modBus);
        IntProviderTypesRegistry.INT_PROVIDER_TYPES.register(modBus);
        HeightProviderTypesRegistry.HEIGHT_PROVIDER_TYPES.register(modBus);
        DimensionRegistry.register();
        AdvancementTriggerRegistry.init();
        this.packetHandler = new NetworkPacketHandler();
        CuriosCompat.init();
        PatchouliCompat.init();
    }

    public static synchronized void addModule(IModModule modModule) {
        modulesLoaded.put(modModule.getName(), modModule);
    }

    public static boolean isModuleLoaded(String moduleName) {
        return modulesLoaded.containsKey(moduleName);
    }

    public static NetworkPacketHandler packetHandler() {
        return Cosmere.instance.packetHandler;
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static Map<Manifestations.ManifestationTypes, ISpiritwebSubmodule> makeSpiritwebSubmodules() {
        HashMap<Manifestations.ManifestationTypes, ISpiritwebSubmodule> spiritwebSubmoduleMap = new HashMap<Manifestations.ManifestationTypes, ISpiritwebSubmodule>();
        for (IModModule iModModule : modulesLoaded.values()) {
            ISpiritwebSubmodule iSpiritwebSubmodule = iModModule.makeSubmodule();
            if (iSpiritwebSubmodule == null) continue;
            Manifestations.ManifestationTypes maniType = null;
            switch (iModModule.getName()) {
                case "Example": {
                    maniType = Manifestations.ManifestationTypes.NONE;
                    break;
                }
                case "Allomancy": {
                    maniType = Manifestations.ManifestationTypes.ALLOMANCY;
                    break;
                }
                case "Feruchemy": {
                    maniType = Manifestations.ManifestationTypes.FERUCHEMY;
                    break;
                }
                case "Hemalurgy": {
                    maniType = Manifestations.ManifestationTypes.HEMALURGY;
                    break;
                }
                case "Surgebinding": {
                    maniType = Manifestations.ManifestationTypes.SURGEBINDING;
                    break;
                }
                case "Sandmastery": {
                    maniType = Manifestations.ManifestationTypes.SANDMASTERY;
                    break;
                }
                case "Aviar": {
                    maniType = Manifestations.ManifestationTypes.AVIAR;
                }
            }
            spiritwebSubmoduleMap.put(maniType, iSpiritwebSubmodule);
        }
        return spiritwebSubmoduleMap;
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        CosmereAPI.logger.info("Cosmere Version {} initializing...", (Object)this.versionNumber);
        this.packetHandler.initialize();
    }

    private void onConfigLoad(ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof CosmereModConfig) {
            CosmereModConfig cosmereModConfig = (CosmereModConfig)config;
            cosmereModConfig.clearCache();
        }
    }

    private void onConfigReload(ModConfigEvent.Reloading configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof CosmereModConfig) {
            CosmereModConfig cosmereModConfig = (CosmereModConfig)config;
            cosmereModConfig.clearCache();
        }
    }

    private void onAddCaps(RegisterCapabilitiesEvent capabilitiesEvent) {
        capabilitiesEvent.register(SpiritwebCapability.class);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ColorHandler::init);
    }
}

