/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.commands.subcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.text.TextHelper;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.commands.arguments.AllomancyArgumentType;
import leaf.cosmere.common.commands.arguments.FeruchemyArgumentType;
import leaf.cosmere.common.commands.subcommands.ManifestationCommand;
import leaf.cosmere.common.commands.subcommands.ModCommand;
import leaf.cosmere.common.config.CosmereConfigs;
import leaf.cosmere.common.config.CosmereServerConfig;
import leaf.cosmere.common.eventHandlers.EntityEventHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;

public class ChooseMetalbornPowersCommand
extends ModCommand {
    private static final HashMap<UUID, CommandQueueItem> commandConfirmationQueue = new HashMap();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"choose_metalborn_powers").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"allomanticPower", (ArgumentType)AllomancyArgumentType.createArgument()).requires(CommandSourceStack::m_230897_)).executes(ChooseMetalbornPowersCommand::addMetalbornPowers)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"feruchemicalPower", (ArgumentType)FeruchemyArgumentType.createArgument()).requires(CommandSourceStack::m_230897_)).executes(ChooseMetalbornPowersCommand::addMetalbornPowers)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"confirm").requires(CommandSourceStack::m_230897_)).executes(ChooseMetalbornPowersCommand::confirmMetalbornPowers))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"random").requires(CommandSourceStack::m_230897_)).executes(ChooseMetalbornPowersCommand::random))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").requires(context -> context.m_6761_(2))).executes(ChooseMetalbornPowersCommand::resetPowers)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(ChooseMetalbornPowersCommand::resetPowers)));
    }

    private static int addMetalbornPowers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!ModList.get().isLoaded("allomancy") || !ModList.get().isLoaded("feruchemy")) {
            source.m_81352_((Component)Component.m_237113_((String)"Allomancer or Feruchemist not installed; cannot choose powers"));
            return 1;
        }
        ServerPlayer player = source.m_81375_();
        AtomicBoolean isInitialized = new AtomicBoolean(false);
        SpiritwebCapability.get((LivingEntity)player).ifPresent(spiritweb -> {
            SpiritwebCapability spiritwebCap = (SpiritwebCapability)spiritweb;
            isInitialized.set(spiritwebCap.hasBeenInitialized());
        });
        if (CosmereConfigs.SERVER_CONFIG.POWER_GENERATION.get() == CosmereServerConfig.PowerGeneration.PICK && !isInitialized.get()) {
            boolean isCompoundingPair;
            Manifestation allomanticPower = (Manifestation)context.getArgument("allomanticPower", Manifestation.class);
            Manifestation feruchemicalPower = (Manifestation)context.getArgument("feruchemicalPower", Manifestation.class);
            boolean allomanticIsValid = allomanticPower.getManifestationType().equals((Object)Manifestations.ManifestationTypes.ALLOMANCY) || allomanticPower.getName().equals("none");
            boolean feruchemicalIsValid = feruchemicalPower.getManifestationType().equals((Object)Manifestations.ManifestationTypes.FERUCHEMY) || feruchemicalPower.getName().equals("none");
            boolean bl = isCompoundingPair = allomanticPower.getName().equals(feruchemicalPower.getName()) || allomanticPower.getName().equals(Metals.MetalType.ELECTRUM.m_6082_()) && feruchemicalPower.getName().equals(Metals.MetalType.ATIUM.m_6082_()) || allomanticPower.getName().equals(Metals.MetalType.ATIUM.m_6082_()) && feruchemicalPower.getName().equals(Metals.MetalType.ELECTRUM.m_6082_());
            if (allomanticIsValid && feruchemicalIsValid && !isCompoundingPair) {
                CommandQueueItem queueItem = new CommandQueueItem(allomanticPower, feruchemicalPower, false);
                commandConfirmationQueue.put(player.m_20148_(), queueItem);
                source.m_243053_((Component)Component.m_237113_((String)("You have chosen \u00a7aallomantic " + allomanticPower.getName() + " \u00a7fand \u00a7aferuchemical " + feruchemicalPower.getName())));
                ChooseMetalbornPowersCommand.sendConfirmationMessage(source);
            } else {
                if (!allomanticIsValid) {
                    source.m_81352_((Component)Component.m_237113_((String)"Invalid argument; argument 1 is not allomantic or none"));
                }
                if (!feruchemicalIsValid) {
                    source.m_81352_((Component)Component.m_237113_((String)"Invalid argument; argument 2 is not feruchemical or none"));
                }
                if (isCompoundingPair) {
                    source.m_81352_((Component)Component.m_237113_((String)"Cannot choose compounding pair"));
                }
            }
        } else if (CosmereConfigs.SERVER_CONFIG.POWER_GENERATION.get() != CosmereServerConfig.PowerGeneration.PICK) {
            source.m_81352_((Component)Component.m_237113_((String)"Server config does not allow non-random metalborn choice"));
        } else if (isInitialized.get()) {
            source.m_81352_((Component)Component.m_237113_((String)"Powers already chosen; cannot choose again"));
        }
        return 1;
    }

    private static int confirmMetalbornPowers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        if (commandConfirmationQueue.containsKey(player.m_20148_())) {
            CommandQueueItem queueItem = commandConfirmationQueue.get(player.m_20148_());
            SpiritwebCapability.get((LivingEntity)player).ifPresent(spiritweb -> {
                SpiritwebCapability spiritwebCap = (SpiritwebCapability)spiritweb;
                if (!queueItem.randomPowers) {
                    if (!queueItem.allomanticPower.getManifestationType().equals((Object)Manifestations.ManifestationTypes.NONE)) {
                        spiritweb.giveManifestation(queueItem.allomanticPower, 9);
                        source.m_288197_(() -> Component.m_237113_((String)("Successfully added allomantic " + queueItem.allomanticPower.getName() + " to " + player.m_7755_().getString())), false);
                        spiritwebCap.getSubmodule(Manifestations.ManifestationTypes.ALLOMANCY).GiveStartingItem((Player)player, queueItem.allomanticPower);
                    }
                    if (!queueItem.feruchemicalPower.getManifestationType().equals((Object)Manifestations.ManifestationTypes.NONE)) {
                        spiritweb.giveManifestation(queueItem.feruchemicalPower, 9);
                        source.m_288197_(() -> Component.m_237113_((String)("Successfully added feruchemical " + queueItem.feruchemicalPower.getName() + " to " + player.m_7755_().getString())), false);
                        spiritwebCap.getSubmodule(Manifestations.ManifestationTypes.FERUCHEMY).GiveStartingItem((Player)player, queueItem.feruchemicalPower);
                    }
                    EntityEventHandler.addOtherPowers(spiritwebCap);
                } else {
                    EntityEventHandler.giveEntityStartingManifestation((LivingEntity)player, spiritwebCap);
                    spiritwebCap.setHasBeenInitialized();
                }
                spiritwebCap.setHasBeenInitialized();
                ManifestationCommand.ReportPowersFoundOnPlayer(context, player);
                spiritweb.syncToClients(null);
            });
            commandConfirmationQueue.remove(player.m_20148_());
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No powers selected."));
        }
        return 1;
    }

    private static int random(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        AtomicBoolean isInitialized = new AtomicBoolean(false);
        SpiritwebCapability.get((LivingEntity)source.m_81375_()).ifPresent(spiritweb -> {
            SpiritwebCapability spiritwebCap = (SpiritwebCapability)spiritweb;
            isInitialized.set(spiritwebCap.hasBeenInitialized());
        });
        if (!isInitialized.get()) {
            Entity entity = source.m_81373_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                CommandQueueItem queueItem = new CommandQueueItem(null, null, true);
                commandConfirmationQueue.put(player.m_20148_(), queueItem);
                source.m_243053_((Component)Component.m_237113_((String)"You have chosen to receive \u00a7arandom powers"));
                ChooseMetalbornPowersCommand.sendConfirmationMessage(source);
            }
        } else {
            source.m_81352_((Component)Component.m_237113_((String)"Powers already chosen; cannot choose again"));
        }
        return 1;
    }

    private static int resetPowers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ChooseMetalbornPowersCommand.getPlayers(context, 3);
        for (ServerPlayer player : players) {
            SpiritwebCapability.get((LivingEntity)player).ifPresent(spiritweb -> {
                spiritweb.clearManifestations();
                ((SpiritwebCapability)spiritweb).setHasNotBeenInitialized();
                spiritweb.syncToClients(null);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Successfully reset player " + player.m_7755_().getString())), false);
            });
        }
        return 1;
    }

    private static void sendConfirmationMessage(CommandSourceStack source) {
        String command = "/cosmere choose_metalborn_powers confirm";
        MutableComponent confirmComponent = Component.m_237113_((String)"\u00a76Click ");
        confirmComponent.m_7220_((Component)TextHelper.createTextWithTooltip(Component.m_237113_((String)"\u00a7a\u00a7nhere\u00a7r ").m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command))), Component.m_237113_((String)"Confirm")));
        confirmComponent.m_7220_((Component)Component.m_237113_((String)"\u00a76to confirm power choice"));
        source.m_288197_(() -> confirmComponent, false);
    }

    public int run(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        return 1;
    }

    private record CommandQueueItem(Manifestation allomanticPower, Manifestation feruchemicalPower, boolean randomPowers) {
    }
}

