/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.config;

import leaf.cosmere.common.config.ICosmereConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class CosmereClientConfig
implements ICosmereConfig {
    private final ForgeConfigSpec configSpec;
    public final ForgeConfigSpec.BooleanValue disableItemTinting;
    public final ForgeConfigSpec.BooleanValue disableSelectedManifestationHud;
    public final ForgeConfigSpec.IntValue hudXCoordinate;
    public final ForgeConfigSpec.IntValue hudYCoordinate;
    public final ForgeConfigSpec.IntValue hudSize;

    CosmereClientConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Client Config. This config only exists on the client").push("cosmere");
        this.disableItemTinting = builder.comment("Lets you disable cosmere item and block tinting for metal items and blocks").define("disableItemTinting", false);
        this.disableSelectedManifestationHud = builder.comment("Disables the HUD for selected power").define("disableSelectedManifestationHud", false);
        this.hudXCoordinate = builder.comment("X coordinate for the HUD").defineInRange("hudXCoordinate", 10, 0, Integer.MAX_VALUE);
        this.hudYCoordinate = builder.comment("Y coordinate for the HUD").defineInRange("hudYCoordinate", 20, 0, Integer.MAX_VALUE);
        this.hudSize = builder.comment("Size of the icon in the HUD; both width and height").defineInRange("hudSize", 40, 0, Integer.MAX_VALUE);
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public String getFileName() {
        return "CosmereClient";
    }

    @Override
    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.CLIENT;
    }

    @Override
    public void clearCache() {
        this.disableItemTinting.clearCache();
    }
}

