/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.items;

import java.util.List;
import java.util.UUID;
import leaf.cosmere.api.text.TextHelper;
import leaf.cosmere.common.charge.IChargeable;
import leaf.cosmere.common.items.BaseItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class ChargeableItemBase
extends BaseItem
implements IChargeable {
    public ChargeableItemBase(Item.Properties prop) {
        super(prop);
    }

    public void addFilled(CreativeModeTab.Output output) {
        output.m_246342_(new ItemStack((ItemLike)this));
        ItemStack fullPower = new ItemStack((ItemLike)this);
        this.setCharge(fullPower, this.getMaxCharge(fullPower));
        output.m_246342_(fullPower);
    }

    public int getEntityLifespan(ItemStack itemStack, Level world) {
        return Integer.MAX_VALUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        String attunedPlayerName = this.getAttunedPlayerName(stack);
        UUID attunedPlayer = this.getAttunedPlayer(stack);
        if (attunedPlayer != null) {
            tooltip.add((Component)TextHelper.createText(attunedPlayerName));
        }
        tooltip.add((Component)TextHelper.createText(String.format("%s/%s", this.getCharge(stack), this.getMaxCharge(stack))).m_130940_(ChatFormatting.GRAY));
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return this.getCharge(stack) > 1;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        int maxCharge = this.getMaxCharge(stack);
        int charge = this.getCharge(stack);
        return this.getBarWidth(charge, maxCharge);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return this.getBarColour(this.getCharge(stack), this.getMaxCharge(stack));
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return this.getCharge(stack) > 0;
    }
}

