/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.function.Supplier;
import leaf.cosmere.api.helpers.EntityHelper;
import leaf.cosmere.common.registry.AttributesRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class FortuneBonusModifier
extends LootModifier {
    public static final Supplier<Codec<FortuneBonusModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> FortuneBonusModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, FortuneBonusModifier::new)));

    protected FortuneBonusModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        String hasCosmereFortuneBonus = "HasCosmereFortuneBonus";
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        if (!(tool == null || tool.m_41782_() && tool.m_41783_() != null && tool.m_41783_().m_128471_("HasCosmereFortuneBonus"))) {
            LivingEntity livingEntity;
            int totalFortuneBonus;
            Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
            BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
            Vec3 origin = (Vec3)context.m_78953_(LootContextParams.f_81460_);
            if (blockState != null && entity instanceof LivingEntity && (totalFortuneBonus = (int)EntityHelper.getAttributeValue(livingEntity = (LivingEntity)entity, AttributesRegistry.COSMERE_FORTUNE.getAttribute())) != 0) {
                ItemStack fakeTool = tool.m_41619_() ? new ItemStack((ItemLike)Items.f_42127_) : tool.m_41777_();
                fakeTool.m_41784_().m_128379_("HasCosmereFortuneBonus", true);
                Map enchantments = EnchantmentHelper.m_44831_((ItemStack)fakeTool);
                enchantments.put(Enchantments.f_44987_, EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44987_, (ItemStack)fakeTool) + totalFortuneBonus);
                EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)fakeTool);
                LootParams lootparams = new LootParams.Builder(context.m_78952_()).m_287286_(LootContextParams.f_81460_, (Object)origin).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287286_(LootContextParams.f_81461_, (Object)blockState).m_287286_(LootContextParams.f_81463_, (Object)fakeTool).m_287235_(LootContextParamSets.f_81421_);
                LootTable lootTable = context.m_78952_().m_7654_().m_278653_().m_278676_(blockState.m_60734_().m_60589_());
                return lootTable.m_287195_(lootparams);
            }
        }
        return generatedLoot;
    }
}

