/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.network.packets;

import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.network.ICosmerePacket;
import leaf.cosmere.common.registry.ManifestationRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class ChangeManifestationModeMessage
implements ICosmerePacket {
    Manifestation manifestation;
    int modifier;

    public ChangeManifestationModeMessage(Manifestation manifestation, int dir) {
        this.manifestation = manifestation;
        this.modifier = dir;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer sender = context.getSender();
        MinecraftServer server = sender.m_20194_();
        server.m_18689_(() -> SpiritwebCapability.get((LivingEntity)sender).ifPresent(data -> {
            int finalModifier = this.manifestation.getModeModifier((ISpiritweb)data, this.manifestation, this.modifier);
            if (finalModifier == 1) {
                data.nextMode(this.manifestation);
            } else if (finalModifier == -1) {
                data.previousMode(this.manifestation);
            } else if (finalModifier != 0) {
                int newMode = finalModifier + this.manifestation.getMode((ISpiritweb)data);
                data.setMode(this.manifestation, newMode);
            }
            data.syncToClients(null);
        }));
        context.setPacketHandled(true);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        String namespace = this.manifestation.getRegistryName().toString();
        buf.m_130070_(namespace);
        buf.writeInt(this.modifier);
    }

    public static ChangeManifestationModeMessage decode(FriendlyByteBuf buf) {
        String location = buf.m_130277_();
        int dir = buf.readInt();
        return new ChangeManifestationModeMessage(ManifestationRegistry.fromID(location), dir);
    }
}

