/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.registration.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import leaf.cosmere.api.providers.IAttributeProvider;
import leaf.cosmere.common.registration.WrappedDeferredRegister;
import leaf.cosmere.common.registration.impl.AttributeRegistryObject;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.registries.ForgeRegistries;

public class AttributeDeferredRegister
extends WrappedDeferredRegister<Attribute> {
    private final List<IAttributeProvider> allAttributes = new ArrayList<IAttributeProvider>();

    public AttributeDeferredRegister(String modid) {
        super(modid, ForgeRegistries.ATTRIBUTES);
    }

    public <ATTRIBUTE extends Attribute> AttributeRegistryObject<ATTRIBUTE> register(String name, Supplier<? extends ATTRIBUTE> sup) {
        AttributeRegistryObject registeredItem = this.register(name, sup, AttributeRegistryObject::new);
        this.allAttributes.add(registeredItem);
        return registeredItem;
    }

    public AttributeRegistryObject<Attribute> register(String registryName, String modid, float defaultVal, float min, float max) {
        return this.register(registryName, () -> new RangedAttribute("manifestation." + modid + "." + registryName, (double)defaultVal, (double)min, (double)max).m_22084_(true));
    }

    public List<IAttributeProvider> getAllAttributes() {
        return Collections.unmodifiableList(this.allAttributes);
    }
}

