/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.registry;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Metals;
import leaf.cosmere.common.items.GuideItem;
import leaf.cosmere.common.items.MetalIngotItem;
import leaf.cosmere.common.items.MetalNuggetItem;
import leaf.cosmere.common.items.MetalRawOreItem;
import leaf.cosmere.common.registration.impl.ItemDeferredRegister;
import leaf.cosmere.common.registration.impl.ItemRegistryObject;
import net.minecraft.world.item.Item;

public class ItemsRegistry {
    public static final ItemDeferredRegister ITEMS = new ItemDeferredRegister("cosmere");
    public static final ItemRegistryObject<GuideItem> GUIDE = ITEMS.register("guide", GuideItem::new);
    public static final Map<Metals.MetalType, ItemRegistryObject<Item>> METAL_RAW_ORE = Arrays.stream(EnumUtils.METAL_TYPES).filter(Metals.MetalType::hasOre).collect(Collectors.toMap(Function.identity(), type -> ITEMS.register("raw_" + type.m_6082_() + "_ore", () -> new MetalRawOreItem((Metals.MetalType)((Object)type)))));
    public static final Map<Metals.MetalType, ItemRegistryObject<Item>> METAL_RAW_BLEND = Arrays.stream(EnumUtils.METAL_TYPES).filter(Metals.MetalType::isAlloy).collect(Collectors.toMap(Function.identity(), type -> ITEMS.register(type.m_6082_() + "_blend", () -> new MetalRawOreItem((Metals.MetalType)((Object)type)))));
    public static final Map<Metals.MetalType, ItemRegistryObject<Item>> METAL_NUGGETS = Arrays.stream(EnumUtils.METAL_TYPES).filter(type -> type.hasMaterialItem() || type == Metals.MetalType.COPPER).collect(Collectors.toMap(Function.identity(), type -> ITEMS.register(type.m_6082_() + "_nugget", () -> new MetalNuggetItem((Metals.MetalType)((Object)type)))));
    public static final Map<Metals.MetalType, ItemRegistryObject<MetalIngotItem>> METAL_INGOTS = Arrays.stream(EnumUtils.METAL_TYPES).filter(type -> type.hasMaterialItem() && type != Metals.MetalType.COPPER).collect(Collectors.toMap(Function.identity(), type -> ITEMS.register(type.m_6082_() + "_ingot", () -> new MetalIngotItem((Metals.MetalType)((Object)type)))));
}

