/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.world.height;

import java.util.function.Supplier;
import leaf.cosmere.common.resource.ore.BaseOreConfig;
import leaf.cosmere.common.world.height.ConfigurableVerticalAnchor;
import leaf.cosmere.common.world.height.HeightShape;
import net.minecraftforge.common.ForgeConfigSpec;

public record ConfigurableHeightRange(Supplier<HeightShape> shape, ConfigurableVerticalAnchor minInclusive, ConfigurableVerticalAnchor maxInclusive, ForgeConfigSpec.ConfigValue<Integer> plateau) {
    public static ConfigurableHeightRange create(ForgeConfigSpec.Builder builder, String veinType, BaseOreConfig baseConfig) {
        ForgeConfigSpec.EnumValue shape = builder.comment("Distribution shape for placing " + veinType + "s.").defineEnum("shape", (Enum)baseConfig.shape());
        ConfigurableVerticalAnchor minInclusive = ConfigurableVerticalAnchor.create(builder, "minInclusive", "Minimum (inclusive) height anchor for " + veinType + "s.", baseConfig.min(), null);
        ForgeConfigSpec.ConfigValue plat = builder.comment("Half length of short side of trapezoid, only used if shape is TRAPEZOID. A value of zero means the shape is a triangle.").define("plateau", (Object)baseConfig.plateau(), o -> {
            if (o instanceof Integer) {
                Integer value = (Integer)o;
                if (value == 0) {
                    return true;
                }
                return value > 0 && shape.get() == HeightShape.TRAPEZOID;
            }
            return false;
        });
        return new ConfigurableHeightRange((Supplier<HeightShape>)shape, minInclusive, ConfigurableVerticalAnchor.create(builder, "maxInclusive", "Maximum (inclusive) height anchor for " + veinType + "s.", baseConfig.max(), minInclusive), (ForgeConfigSpec.ConfigValue<Integer>)plat);
    }
}

