/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import leaf.cosmere.api.EnumUtils;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.Roshar;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class CosmereTags {

    public static class EntityTypes {
        public static final TagKey<EntityType<?>> CONTAINS_METAL = EntityTypes.create("cosmere", "contains_metal");

        private static TagKey<EntityType<?>> create(String namespace, String path) {
            return EntityTypes.create(new ResourceLocation(namespace, path));
        }

        private static TagKey<EntityType<?>> create(ResourceLocation resourceLocation) {
            return TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)resourceLocation);
        }
    }

    public static class Biomes {
        public static final TagKey<Biome> IS_ROSHAR = Biomes.create(new ResourceLocation("surgebinding", "is_roshar"));
        public static final TagKey<Biome> IS_SHADESMAR = Biomes.create(new ResourceLocation("cosmere", "is_shadesmar"));
        public static final TagKey<Biome> SPAWN_ORES = Biomes.create(new ResourceLocation("cosmere", "spawn_ores"));

        private static TagKey<Biome> create(ResourceLocation resourceLocation) {
            return TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)resourceLocation);
        }
    }

    public static class Blocks {
        public static final TagKey<Block> DRAGON_PROOF = Blocks.makeBlock("minecraft", "dragon_immune");
        public static final TagKey<Block> WITHER_PROOF = Blocks.makeBlock("minecraft", "wither_immune");
        public static final TagKey<Block> CONTAINS_METAL = Blocks.makeBlock("cosmere", "contains_metal");
        public static final Map<Metals.MetalType, TagKey<Block>> METAL_ORE_BLOCK_TAGS = Arrays.stream(EnumUtils.METAL_TYPES).collect(Collectors.toMap(Function.identity(), type -> Blocks.forgeTag("ores/" + type.m_6082_())));
        public static final Map<Metals.MetalType, TagKey<Block>> METAL_BLOCK_TAGS = Arrays.stream(EnumUtils.METAL_TYPES).collect(Collectors.toMap(Function.identity(), type -> Blocks.forgeTag("storage_blocks/" + type.m_6082_())));
        public static final Map<Roshar.Gemstone, TagKey<Block>> GEM_ORE_BLOCK_TAGS = Arrays.stream(EnumUtils.GEMSTONE_TYPES).collect(Collectors.toMap(Function.identity(), type -> Blocks.forgeTag("ores/" + type.getName())));
        public static final Map<Roshar.Gemstone, TagKey<Block>> GEM_BLOCK_TAGS = Arrays.stream(EnumUtils.GEMSTONE_TYPES).collect(Collectors.toMap(Function.identity(), type -> Blocks.forgeTag("storage_blocks/" + type.getName())));

        public static TagKey<Block> makeBlock(String domain, String path) {
            return BlockTags.create((ResourceLocation)new ResourceLocation(domain, path));
        }

        public static TagKey<Block> makeBlock(ResourceLocation resourceLocation) {
            return BlockTags.create((ResourceLocation)resourceLocation);
        }

        private static TagKey<Block> forgeTag(String name) {
            ResourceLocation forgeTagToMake = new ResourceLocation("forge", name);
            return Blocks.makeBlock(forgeTagToMake);
        }
    }

    public static class Items {
        public static final TagKey<Item> CURIO_ANY = Items.makeItem("curios", "curio");
        public static final TagKey<Item> CURIO_BACK = Items.makeItem("curios", "back");
        public static final TagKey<Item> CURIO_BELT = Items.makeItem("curios", "belt");
        public static final TagKey<Item> CURIO_BODY = Items.makeItem("curios", "body");
        public static final TagKey<Item> CURIO_BRACELET = Items.makeItem("curios", "bracelet");
        public static final TagKey<Item> CURIO_CHARM = Items.makeItem("curios", "charm");
        public static final TagKey<Item> CURIO_HEAD = Items.makeItem("curios", "head");
        public static final TagKey<Item> CURIO_HANDS = Items.makeItem("curios", "hands");
        public static final TagKey<Item> CURIO_NECKLACE = Items.makeItem("curios", "necklace");
        public static final TagKey<Item> CURIO_RING = Items.makeItem("curios", "ring");
        public static final TagKey<Item> CURIO_LEGS = Items.makeItem("curios", "legs");
        public static final TagKey<Item> CURIO_FEET = Items.makeItem("curios", "feet");
        public static final TagKey<Item> CURIO_EYES = Items.makeItem("curios", "eyes");
        public static final TagKey<Item> CURIO_LINCHPIN = Items.makeItem("curios", "linchpin");
        public static final TagKey<Item> CURIO_PHYSICAL = Items.makeItem("curios", "physical");
        public static final TagKey<Item> CURIO_MENTAL = Items.makeItem("curios", "mental");
        public static final TagKey<Item> CURIO_TEMPORAL = Items.makeItem("curios", "temporal");
        public static final TagKey<Item> CURIO_SPIRITUAL = Items.makeItem("curios", "spiritual");
        public static final TagKey<Item> CONTAINS_METAL = Items.makeItem("cosmere", "contains_metal");
        public static final TagKey<Item> METAL_SPIKE = Items.makeItem("cosmere", "spike");
        public static final Map<Metals.MetalType, TagKey<Item>> METAL_RAW_TAGS = Arrays.stream(EnumUtils.METAL_TYPES).collect(Collectors.toMap(Function.identity(), type -> Items.forgeItemTag("raw_materials/" + type.m_6082_())));
        public static final Map<Metals.MetalType, TagKey<Item>> METAL_ORE_TAGS = Arrays.stream(EnumUtils.METAL_TYPES).collect(Collectors.toMap(Function.identity(), type -> Items.forgeItemTag("ores/" + type.m_6082_())));
        public static final Map<Metals.MetalType, TagKey<Item>> METAL_DUST_TAGS = Arrays.stream(EnumUtils.METAL_TYPES).collect(Collectors.toMap(Function.identity(), type -> Items.forgeItemTag("dusts/" + type.m_6082_())));
        public static final Map<Metals.MetalType, TagKey<Item>> METAL_NUGGET_TAGS = Arrays.stream(EnumUtils.METAL_TYPES).collect(Collectors.toMap(Function.identity(), type -> Items.forgeItemTag("nuggets/" + type.m_6082_())));
        public static final Map<Metals.MetalType, Map<Metals.MetalType, TagKey<Item>>> GOD_METAL_ALLOY_NUGGET_TAGS = Arrays.stream(new Metals.MetalType[]{Metals.MetalType.LERASIUM, Metals.MetalType.LERASATIUM}).collect(Collectors.toMap(Function.identity(), god -> Arrays.stream(EnumUtils.METAL_TYPES).filter(base -> !base.isGodMetal()).collect(Collectors.toMap(Function.identity(), base -> Items.forgeItemTag("nuggets/" + god.m_6082_() + "_" + base.m_6082_() + "_alloy")))));
        public static final Map<Metals.MetalType, TagKey<Item>> METAL_INGOT_TAGS = Arrays.stream(EnumUtils.METAL_TYPES).collect(Collectors.toMap(Function.identity(), type -> Items.forgeItemTag("ingots/" + type.m_6082_())));
        public static final Map<Metals.MetalType, TagKey<Item>> METAL_BLOCK_ITEM_TAGS = Arrays.stream(EnumUtils.METAL_TYPES).collect(Collectors.toMap(Function.identity(), type -> Items.forgeItemTag("storage_blocks/" + type.m_6082_())));
        public static final Map<Roshar.Gemstone, TagKey<Item>> GEM_BLOCK_ITEM_TAGS = Arrays.stream(EnumUtils.GEMSTONE_TYPES).collect(Collectors.toMap(Function.identity(), type -> Items.forgeItemTag("storage_blocks/" + type.getName())));
        public static final Map<Roshar.Gemstone, TagKey<Item>> GEM_TAGS = Arrays.stream(EnumUtils.GEMSTONE_TYPES).collect(Collectors.toMap(Function.identity(), type -> Items.forgeItemTag("gems/" + type.getName())));

        public static TagKey<Item> makeItem(String domain, String path) {
            return ItemTags.create((ResourceLocation)new ResourceLocation(domain, path));
        }

        public static TagKey<Item> makeItem(ResourceLocation resourceLocation) {
            return ItemTags.create((ResourceLocation)resourceLocation);
        }

        private static TagKey<Item> forgeItemTag(String name) {
            ResourceLocation forgeTagToMake = new ResourceLocation("forge", name);
            return Items.makeItem(forgeTagToMake);
        }
    }
}

