/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.api.manifestation;

import leaf.cosmere.api.CosmereAPI;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.providers.IManifestationProvider;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class Manifestation
implements IManifestationProvider {
    protected final Manifestations.ManifestationTypes manifestationType;

    public Manifestation() {
        this.manifestationType = Manifestations.ManifestationTypes.NONE;
    }

    public Manifestation(Manifestations.ManifestationTypes manifestationType) {
        this.manifestationType = manifestationType;
    }

    public Manifestations.ManifestationTypes getManifestationType() {
        return this.manifestationType;
    }

    public int getPowerID() {
        return 0;
    }

    public int getActiveTick(ISpiritweb data) {
        return data.getLiving().f_19797_ + this.getPowerID();
    }

    public boolean isActiveTick(ISpiritweb data) {
        return this.getActiveTick(data) % 20 == 0;
    }

    public void onModeChange(ISpiritweb data, int lastMode) {
    }

    public int getMode(ISpiritweb data) {
        return data.getMode(this);
    }

    public int getModeModifier(ISpiritweb data, Manifestation manifestation, int requestedModifier) {
        return requestedModifier;
    }

    public int modeMax(ISpiritweb data) {
        return 0;
    }

    public int modeMin(ISpiritweb data) {
        return 0;
    }

    public boolean modeWraps(ISpiritweb data) {
        return false;
    }

    public boolean tick(ISpiritweb data) {
        return false;
    }

    protected void applyEffectTick(ISpiritweb data) {
    }

    public boolean isActive(ISpiritweb data) {
        return data.canTickManifestation(this);
    }

    public double getStrength(ISpiritweb cap, boolean getBaseStrength) {
        AttributeInstance attribute = cap.getLiving().m_21051_(this.getAttribute());
        if (attribute != null) {
            return getBaseStrength ? attribute.m_22115_() : attribute.m_22135_();
        }
        return 0.0;
    }

    @Override
    public ResourceLocation getRegistryName() {
        IForgeRegistry<Manifestation> registry = CosmereAPI.manifestationRegistry();
        return registry == null ? null : registry.getKey((Object)this);
    }

    @Override
    public String getTranslationKey() {
        ResourceLocation regName = this.getRegistryName();
        return "manifestation." + regName.m_135827_() + "." + regName.m_135815_();
    }

    @Override
    public Manifestation getManifestation() {
        return this;
    }

    public Attribute getAttribute() {
        return (Attribute)ForgeRegistries.ATTRIBUTES.getValue(this.getRegistryName());
    }
}

