/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.commands.subcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.api.spiritweb.ISpiritweb;
import leaf.cosmere.api.text.TextHelper;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.commands.arguments.ManifestationsArgumentType;
import leaf.cosmere.common.commands.subcommands.ModCommand;
import leaf.cosmere.common.eventHandlers.EntityEventHandler;
import leaf.cosmere.common.registry.ManifestationRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class ManifestationCommand
extends ModCommand {
    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return 1;
    }

    private static int check(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ManifestationCommand.getPlayers(context, 3);
        for (ServerPlayer player : players) {
            ManifestationCommand.ReportPowersFoundOnPlayer(context, player);
        }
        return 1;
    }

    public static void ReportPowersFoundOnPlayer(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        SpiritwebCapability.get((LivingEntity)player).ifPresent(spiritweb -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            MutableComponent powersFound = Component.m_237110_((String)"command.cosmere.power.found", (Object[])new Object[]{TextHelper.getPlayerTextObject(player.m_284548_(), player.m_20148_())});
            MutableComponent leftBracketTextComponent = Component.m_237113_((String)"[");
            MutableComponent rightBracketTextComponent = Component.m_237113_((String)"]");
            MutableComponent space = Component.m_237113_((String)" ");
            for (Manifestation manifestation : spiritweb.getAvailableManifestations()) {
                powersFound.m_7220_((Component)leftBracketTextComponent);
                double baseStrength = manifestation.getStrength((ISpiritweb)spiritweb, true);
                double totalStrength = manifestation.getStrength((ISpiritweb)spiritweb, false);
                powersFound.m_7220_((Component)TextHelper.createTextWithTooltip((MutableComponent)manifestation.getTextComponent(), Component.m_237110_((String)"command.cosmere.power.strength", (Object[])new Object[]{baseStrength, totalStrength})));
                powersFound.m_7220_((Component)rightBracketTextComponent);
                powersFound.m_7220_((Component)space);
            }
            source.m_288197_(() -> powersFound, true);
        });
    }

    private static int clear(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ManifestationCommand.getPlayers(context, 3);
        for (ServerPlayer player : players) {
            SpiritwebCapability.get((LivingEntity)player).ifPresent(iSpiritweb -> {
                CommandSourceStack source = (CommandSourceStack)context.getSource();
                iSpiritweb.clearManifestations();
                iSpiritweb.syncToClients(null);
                MutableComponent playerTextObject = TextHelper.getPlayerTextObject(((CommandSourceStack)context.getSource()).m_81372_(), player.m_20148_());
                source.m_288197_(() -> Component.m_237110_((String)"command.cosmere.power.set.success", (Object[])new Object[]{playerTextObject}), false);
            });
        }
        return 1;
    }

    private static int reroll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ManifestationCommand.getPlayers(context, 3);
        for (ServerPlayer player : players) {
            SpiritwebCapability.get((LivingEntity)player).ifPresent(iSpiritweb -> {
                CommandSourceStack source = (CommandSourceStack)context.getSource();
                iSpiritweb.clearManifestations();
                EntityEventHandler.giveEntityStartingManifestation((LivingEntity)player, (SpiritwebCapability)iSpiritweb);
                iSpiritweb.setSelectedManifestation((Manifestation)ManifestationRegistry.NONE.get());
                iSpiritweb.syncToClients(null);
                MutableComponent playerTextObject = TextHelper.getPlayerTextObject(player.m_284548_(), player.m_20148_());
                source.m_288197_(() -> Component.m_237110_((String)"command.cosmere.power.set.success", (Object[])new Object[]{playerTextObject}), false);
                ManifestationCommand.ReportPowersFoundOnPlayer(context, player);
            });
        }
        return 1;
    }

    private static int give(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ManifestationCommand.getPlayers(context, 4);
        for (ServerPlayer player : players) {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Manifestation manifestation = (Manifestation)context.getArgument("manifestation", Manifestation.class);
            MutableComponent playerText = TextHelper.getPlayerTextObject(player.m_284548_(), player.m_20148_());
            MutableComponent manifestationText = (MutableComponent)manifestation.getTextComponent();
            SpiritwebCapability.get((LivingEntity)player).ifPresent(spiritweb -> {
                spiritweb.giveManifestation(manifestation, 9);
                source.m_288197_(() -> Component.m_237110_((String)"command.cosmere.power.set.success", (Object[])new Object[]{playerText, manifestationText}), false);
                ManifestationCommand.ReportPowersFoundOnPlayer(context, player);
                spiritweb.syncToClients(null);
            });
        }
        return 1;
    }

    private static int remove(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ManifestationCommand.getPlayers(context, 4);
        for (ServerPlayer player : players) {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Manifestation manifestation = (Manifestation)context.getArgument("manifestation", Manifestation.class);
            MutableComponent playerText = TextHelper.getPlayerTextObject(source.m_81372_(), player.m_20148_());
            MutableComponent manifestationText = (MutableComponent)manifestation.getTextComponent();
            SpiritwebCapability.get((LivingEntity)player).ifPresent(spiritweb -> {
                spiritweb.removeManifestation(manifestation);
                spiritweb.syncToClients(null);
                source.m_288197_(() -> Component.m_237110_((String)"command.cosmere.power.set.success", (Object[])new Object[]{playerText, manifestationText}), false);
                ManifestationCommand.ReportPowersFoundOnPlayer(context, player);
            });
        }
        return 1;
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"powers").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"check").executes(ManifestationCommand::check)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).requires(context -> context.m_6761_(2))).executes(ManifestationCommand::check)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires(context -> context.m_6761_(2))).executes(ManifestationCommand::clear)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(ManifestationCommand::clear)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reroll").requires(context -> context.m_6761_(2))).executes(ManifestationCommand::reroll)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(ManifestationCommand::reroll)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"give").requires(context -> context.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"manifestation", (ArgumentType)ManifestationsArgumentType.createArgument()).executes(ManifestationCommand::give)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(ManifestationCommand::give))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(context -> context.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"manifestation", (ArgumentType)ManifestationsArgumentType.createArgument()).executes(ManifestationCommand::remove)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(ManifestationCommand::remove))));
    }
}

