/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.config;

import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import leaf.cosmere.common.config.ICosmereConfig;
import leaf.cosmere.common.resource.ore.BaseOreConfig;
import leaf.cosmere.common.resource.ore.OreType;
import leaf.cosmere.common.util.CosmereEnumUtils;
import leaf.cosmere.common.world.height.ConfigurableHeightRange;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class CosmereWorldConfig
implements ICosmereConfig {
    private final ForgeConfigSpec configSpec;
    private final Map<OreType, OreConfig> ores = new EnumMap<OreType, OreConfig>(OreType.class);

    CosmereWorldConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("World generation settings for Cosmere. This config is synced from server to client").push("world_generation");
        for (OreType ore : CosmereEnumUtils.ORE_TYPES) {
            this.ores.put(ore, new OreConfig(builder, ore));
        }
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public String getFileName() {
        return "world";
    }

    @Override
    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }

    @Override
    public boolean addToContainer() {
        return false;
    }

    public OreVeinConfig getVeinConfig(OreType.OreVeinType oreVeinType) {
        return this.ores.get((Object)((Object)oreVeinType.type())).veinConfigs.get(oreVeinType.index());
    }

    @Override
    public void clearCache() {
        for (OreType ore : CosmereEnumUtils.ORE_TYPES) {
            OreConfig oreConfig = this.ores.get((Object)ore);
            oreConfig.shouldGenerate.clearCache();
            for (OreVeinConfig veinConfig : oreConfig.veinConfigs) {
                veinConfig.discardChanceOnAirExposure.clearCache();
                veinConfig.maxVeinSize.clearCache();
                veinConfig.perChunk.clearCache();
                veinConfig.range.plateau().clearCache();
            }
        }
    }

    private static class OreConfig {
        private final ForgeConfigSpec.BooleanValue shouldGenerate;
        private final List<OreVeinConfig> veinConfigs;

        private OreConfig(ForgeConfigSpec.Builder builder, OreType oreType) {
            String ore = oreType.getMetalType().m_6082_();
            builder.comment("Generation Settings for " + ore + " ore.").push(ore);
            this.shouldGenerate = builder.comment("Determines if " + ore + " ore should be added to world generation.").define("shouldGenerate", true);
            ImmutableList.Builder veinBuilder = ImmutableList.builder();
            for (BaseOreConfig baseConfig : oreType.getBaseConfigs()) {
                String veinType = baseConfig.name() + " " + ore + " vein";
                builder.comment(veinType + " Generation Settings.").push(baseConfig.name());
                ForgeConfigSpec.BooleanValue shouldVeinTypeGenerate = builder.comment("Determines if " + veinType + "s should be added to world generation. Note: Requires generating " + ore + " ore to be enabled.").define("shouldGenerate", true);
                veinBuilder.add((Object)new OreVeinConfig(() -> (Boolean)this.shouldGenerate.get() != false && (Boolean)shouldVeinTypeGenerate.get() != false, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Chance that " + veinType + "s generates in a chunk.").defineInRange("perChunk", baseConfig.perChunk(), 1, 256), (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Maximum number of blocks in a " + veinType + ".").defineInRange("maxVeinSize", baseConfig.maxVeinSize(), 1, 64), (ForgeConfigSpec.ConfigValue<Double>)builder.comment("Chance that blocks that are directly exposed to air in a " + veinType + " are not placed.").defineInRange("discardChanceOnAirExposure", baseConfig.discardChanceOnAirExposure(), 0.0, 1.0), ConfigurableHeightRange.create(builder, veinType, baseConfig)));
                builder.pop();
            }
            this.veinConfigs = veinBuilder.build();
            builder.pop();
        }
    }

    public record OreVeinConfig(BooleanSupplier shouldGenerate, ForgeConfigSpec.ConfigValue<Integer> perChunk, ForgeConfigSpec.ConfigValue<Integer> maxVeinSize, ForgeConfigSpec.ConfigValue<Double> discardChanceOnAirExposure, ConfigurableHeightRange range) {
    }
}

