/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.items;

import java.util.ArrayList;
import java.util.List;
import leaf.cosmere.api.IGrantsManifestations;
import leaf.cosmere.api.IHasSize;
import leaf.cosmere.api.Manifestations;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.manifestation.Manifestation;
import leaf.cosmere.common.cap.entity.SpiritwebCapability;
import leaf.cosmere.common.items.AlloyNuggetItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GodMetalAlloyNuggetItem
extends AlloyNuggetItem
implements IHasSize,
IGrantsManifestations {
    public static int MIN_SIZE = 1;
    public static int MAX_SIZE = 16;

    @Override
    public int getMinSize() {
        return MIN_SIZE;
    }

    @Override
    public int getMaxSize() {
        return MAX_SIZE;
    }

    public GodMetalAlloyNuggetItem(Metals.MetalType metalType, Metals.MetalType alloyedMetalType) {
        super(metalType, alloyedMetalType);
    }

    public void addFilled(CreativeModeTab.Output output, int size) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        this.writeMetalAlloySizeNbtData(itemStack, size);
        output.m_246342_(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Integer size = this.readMetalAlloySizeNbtData(stack);
        MutableComponent metalListComponent = Component.m_237119_();
        metalListComponent.m_7220_((Component)Component.m_237115_((String)this.getMetalType().getTranslationKey()).m_130948_(Style.f_131099_.m_178520_(this.getMetalType().getColorValue())));
        metalListComponent.m_7220_((Component)Component.m_237113_((String)" / ").m_130940_(ChatFormatting.WHITE));
        metalListComponent.m_7220_((Component)Component.m_237115_((String)this.alloyedMetalType.getTranslationKey()).m_130948_(Style.f_131099_.m_178520_(this.alloyedMetalType.getColorValue())));
        tooltip.add((Component)metalListComponent);
        tooltip.add((Component)Component.m_237113_((String)"Size: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)(size + "/" + MAX_SIZE)).m_130940_(ChatFormatting.GRAY)));
        ArrayList<Manifestation> manifestations = this.determineManifestations(stack);
        if (!manifestations.isEmpty() & size != null) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237113_((String)"When consumed:").m_130940_(ChatFormatting.GOLD));
            for (Manifestation manifestation : manifestations) {
                tooltip.add((Component)Component.m_237113_((String)("+" + size + " ")).m_7220_((Component)Component.m_237115_((String)manifestation.getTranslationKey())).m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    public Rarity m_41460_(ItemStack itemStack) {
        Integer size = this.readMetalAlloySizeNbtData(itemStack);
        if (size == null) {
            return Rarity.COMMON;
        }
        if (size <= 8) {
            return Rarity.UNCOMMON;
        }
        if (size == MAX_SIZE) {
            return Rarity.EPIC;
        }
        return Rarity.RARE;
    }

    @Override
    public ArrayList<Manifestation> determineManifestations(ItemStack itemStack) {
        Manifestation manifestation;
        ArrayList<Manifestation> manifestations = new ArrayList<Manifestation>();
        if (this.getMetalType() == Metals.MetalType.LERASIUM) {
            Manifestation manifestation2 = Manifestations.ManifestationTypes.ALLOMANCY.getManifestation(this.alloyedMetalType.getID());
            if (manifestation2.getManifestationType() != Manifestations.ManifestationTypes.NONE) {
                manifestations.add(manifestation2);
            }
        } else if (this.getMetalType() == Metals.MetalType.LERASATIUM && (manifestation = Manifestations.ManifestationTypes.FERUCHEMY.getManifestation(this.alloyedMetalType.getID())).getManifestationType() != Manifestations.ManifestationTypes.NONE) {
            manifestations.add(manifestation);
        }
        return manifestations;
    }

    @Override
    public void grantManifestations(LivingEntity livingEntity, ArrayList<Manifestation> manifestations, int strength) {
        SpiritwebCapability.get(livingEntity).ifPresent(iSpiritweb -> {
            SpiritwebCapability spiritweb = (SpiritwebCapability)iSpiritweb;
            for (Manifestation manifestation : manifestations) {
                int newStrength;
                int currentStrength = 0;
                Attribute patt4953$temp = manifestation.getAttribute();
                if (!(patt4953$temp instanceof RangedAttribute)) {
                    return;
                }
                RangedAttribute attribute = (RangedAttribute)patt4953$temp;
                AttributeInstance attributeInstance = livingEntity.m_21051_((Attribute)attribute);
                if (attributeInstance != null) {
                    currentStrength = (int)attributeInstance.m_22135_();
                }
                if ((double)(newStrength = strength + currentStrength) < attribute.m_147361_()) {
                    newStrength = (int)attribute.m_147361_();
                } else if ((double)newStrength > attribute.m_147362_()) {
                    newStrength = (int)attribute.m_147362_();
                }
                spiritweb.giveManifestation(manifestation, newStrength);
            }
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                spiritweb.syncToClients(serverPlayer);
            }
        });
    }
}

