/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.recipes;

import javax.annotation.Nonnull;
import leaf.cosmere.api.IHasSize;
import leaf.cosmere.api.Metals;
import leaf.cosmere.api.providers.IItemProvider;
import leaf.cosmere.common.items.AlloyNuggetItem;
import leaf.cosmere.common.items.GodMetalAlloyNuggetItem;
import leaf.cosmere.common.items.GodMetalNuggetItem;
import leaf.cosmere.common.items.MetalNuggetItem;
import leaf.cosmere.common.registry.CosmereRecipesRegistry;
import leaf.cosmere.common.registry.ItemsRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GodMetalNuggetsCompress
extends CustomRecipe {
    Ingredient INGREDIENT_GOD_METAL_ALLOY_NUG = Ingredient.m_43921_(ItemsRegistry.GOD_METAL_ALLOY_NUGGETS.values().stream().flatMap(inner -> inner.values().stream()).map(IItemProvider::getItemStack));
    Ingredient INGREDIENT_GOD_METAL_NUG = Ingredient.m_43921_(ItemsRegistry.GOD_METAL_NUGGETS.values().stream().map(IItemProvider::getItemStack));

    public GodMetalNuggetsCompress(ResourceLocation loc, CraftingBookCategory pCategory) {
        super(loc, pCategory);
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        Metals.MetalType godMetalType = null;
        Metals.MetalType alloyedMetalType = null;
        int totalSize = 0;
        int numItems = 0;
        boolean isAlloy = false;
        boolean isGod = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            MetalNuggetItem item;
            ItemStack itemStack = inv.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            if (this.INGREDIENT_GOD_METAL_ALLOY_NUG.test(inv.m_8020_(i))) {
                isAlloy = true;
                ++numItems;
                item = (GodMetalAlloyNuggetItem)itemStack.m_41720_();
                if (godMetalType == null) {
                    godMetalType = item.getMetalType();
                }
                if (godMetalType != item.getMetalType()) {
                    return false;
                }
                if (alloyedMetalType == null) {
                    alloyedMetalType = ((AlloyNuggetItem)item).getAlloyedMetalType();
                }
                if (alloyedMetalType != ((AlloyNuggetItem)item).getAlloyedMetalType()) {
                    return false;
                }
                if ((totalSize += item.readMetalAlloySizeNbtData(itemStack).intValue()) <= ((GodMetalAlloyNuggetItem)item).getMaxSize()) continue;
                return false;
            }
            if (this.INGREDIENT_GOD_METAL_NUG.test(inv.m_8020_(i))) {
                isGod = true;
                ++numItems;
                item = (GodMetalNuggetItem)itemStack.m_41720_();
                if (godMetalType == null) {
                    godMetalType = item.getMetalType();
                }
                if (godMetalType != item.getMetalType()) {
                    return false;
                }
                if ((totalSize += item.readMetalAlloySizeNbtData(itemStack).intValue()) <= ((GodMetalNuggetItem)item).getMaxSize()) continue;
                return false;
            }
            return false;
        }
        if (numItems < 2) {
            return false;
        }
        return !isGod || !isAlloy;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess pRegistryAccess) {
        int totalSize = 0;
        Metals.MetalType godMetalType = null;
        Metals.MetalType alloyedMetalType = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            MetalNuggetItem curItem;
            if (inv.m_8020_(i).m_41619_()) continue;
            ItemStack curItemStack = inv.m_8020_(i);
            if (this.INGREDIENT_GOD_METAL_ALLOY_NUG.test(inv.m_8020_(i))) {
                curItem = (GodMetalAlloyNuggetItem)curItemStack.m_41720_();
                godMetalType = curItem.getMetalType();
                alloyedMetalType = ((AlloyNuggetItem)curItem).getAlloyedMetalType();
                totalSize += curItem.readMetalAlloySizeNbtData(curItemStack).intValue();
                continue;
            }
            if (!this.INGREDIENT_GOD_METAL_NUG.test(inv.m_8020_(i))) continue;
            curItem = (GodMetalNuggetItem)curItemStack.m_41720_();
            godMetalType = curItem.getMetalType();
            totalSize += curItem.readMetalAlloySizeNbtData(curItemStack).intValue();
        }
        ItemStack itemStack = alloyedMetalType != null ? new ItemStack((ItemLike)ItemsRegistry.GOD_METAL_ALLOY_NUGGETS.get((Object)godMetalType).get((Object)alloyedMetalType)) : new ItemStack((ItemLike)ItemsRegistry.GOD_METAL_NUGGETS.get((Object)godMetalType));
        IHasSize item = (IHasSize)itemStack.m_41720_();
        item.writeMetalAlloySizeNbtData(itemStack, totalSize);
        itemStack.m_41764_(1);
        return itemStack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height == 9;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return new ResourceLocation("cosmere", "crafting_god_metal_nuggets_compress");
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CosmereRecipesRegistry.GOD_METAL_NUGGETS_COMPRESS.get();
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pContainer) {
        return NonNullList.m_122780_((int)pContainer.m_6643_(), (Object)ItemStack.f_41583_);
    }
}

