/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.recipes;

import javax.annotation.Nonnull;
import leaf.cosmere.api.IHasSize;
import leaf.cosmere.api.providers.IItemProvider;
import leaf.cosmere.common.items.GodMetalAlloyNuggetItem;
import leaf.cosmere.common.items.GodMetalNuggetItem;
import leaf.cosmere.common.registry.CosmereRecipesRegistry;
import leaf.cosmere.common.registry.ItemsRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GodMetalNuggetsDecompress
extends CustomRecipe {
    Ingredient INGREDIENT_GOD_METAL_ALLOY_NUG = Ingredient.m_43921_(ItemsRegistry.GOD_METAL_ALLOY_NUGGETS.values().stream().flatMap(inner -> inner.values().stream()).map(IItemProvider::getItemStack));
    Ingredient INGREDIENT_GOD_METAL_NUG = Ingredient.m_43921_(ItemsRegistry.GOD_METAL_NUGGETS.values().stream().map(IItemProvider::getItemStack));

    public GodMetalNuggetsDecompress(ResourceLocation loc, CraftingBookCategory pCategory) {
        super(loc, pCategory);
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        int itemCount = 0;
        IHasSize item = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemStack = inv.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            if (this.INGREDIENT_GOD_METAL_ALLOY_NUG.test(inv.m_8020_(i)) || this.INGREDIENT_GOD_METAL_NUG.test(inv.m_8020_(i))) {
                if (++itemCount > 1) {
                    return false;
                }
                item = (IHasSize)itemStack.m_41720_();
                int currentSize = item.readMetalAlloySizeNbtData(itemStack);
                if (currentSize == item.getMinSize()) {
                    return false;
                }
                if (currentSize % 2 != 1) continue;
                return false;
            }
            return false;
        }
        return itemCount == true;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess pRegistryAccess) {
        Item item = null;
        int index = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (inv.m_8020_(i).m_41619_()) continue;
            item = inv.m_8020_(i).m_41720_();
            index = i;
            break;
        }
        ItemStack itemStack = ItemStack.f_41583_;
        if (this.INGREDIENT_GOD_METAL_ALLOY_NUG.test(inv.m_8020_(index))) {
            GodMetalAlloyNuggetItem gItem = (GodMetalAlloyNuggetItem)item;
            int currentSize = gItem.readMetalAlloySizeNbtData(inv.m_8020_(index));
            itemStack = new ItemStack((ItemLike)ItemsRegistry.GOD_METAL_ALLOY_NUGGETS.get((Object)gItem.getMetalType()).get((Object)gItem.getAlloyedMetalType()));
            gItem.writeMetalAlloySizeNbtData(itemStack, currentSize / 2);
            itemStack.m_41764_(2);
        } else if (this.INGREDIENT_GOD_METAL_NUG.test(inv.m_8020_(index))) {
            GodMetalNuggetItem gItem = (GodMetalNuggetItem)item;
            int currentSize = gItem.readMetalAlloySizeNbtData(inv.m_8020_(index));
            itemStack = new ItemStack((ItemLike)ItemsRegistry.GOD_METAL_NUGGETS.get((Object)gItem.getMetalType()));
            gItem.writeMetalAlloySizeNbtData(itemStack, currentSize / 2);
            itemStack.m_41764_(2);
        }
        return itemStack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height == 9;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return new ResourceLocation("cosmere", "crafting_god_metal_nuggets_decompress");
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CosmereRecipesRegistry.GOD_METAL_NUGGETS_DECOMPRESS.get();
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pContainer) {
        return NonNullList.m_122780_((int)pContainer.m_6643_(), (Object)ItemStack.f_41583_);
    }
}

