/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.resource.ore;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import leaf.cosmere.api.Metals;
import leaf.cosmere.common.resource.ore.BaseOreConfig;
import leaf.cosmere.common.resource.ore.OreAnchor;
import leaf.cosmere.common.world.height.HeightShape;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum OreType implements StringRepresentable
{
    TIN(Metals.MetalType.TIN, new BaseOreConfig("small", 14, 0.0f, 4, HeightShape.TRAPEZOID, OreAnchor.absolute(-20), OreAnchor.absolute(94)), new BaseOreConfig("medium", 12, 0.0f, 7, HeightShape.TRAPEZOID, OreAnchor.absolute(-32), OreAnchor.absolute(72)), new BaseOreConfig("abundant", 20, 0.0f, 6, HeightShape.UNIFORM, OreAnchor.aboveBottom(-64), OreAnchor.aboveBottom(32))),
    ZINC(Metals.MetalType.ZINC, new BaseOreConfig("upper", 65, 0.0, 7, HeightShape.TRAPEZOID, OreAnchor.absolute(72), OreAnchor.belowTop(-24), 8), new BaseOreConfig("middle", 6, 0.0f, 9, HeightShape.TRAPEZOID, OreAnchor.absolute(-32), OreAnchor.absolute(56)), new BaseOreConfig("deep", 10, 0.2f, 10, HeightShape.TRAPEZOID, OreAnchor.aboveBottom(-80), OreAnchor.absolute(-32))),
    ALUMINUM(Metals.MetalType.ALUMINUM, new BaseOreConfig("small", 4, 0.0f, 4, HeightShape.TRAPEZOID, OreAnchor.aboveBottom(0), OreAnchor.absolute(8)), new BaseOreConfig("medium", 8, 0.0f, 4, HeightShape.UNIFORM, OreAnchor.aboveBottom(-60), OreAnchor.absolute(-50)), new BaseOreConfig("buried", 13, 0.75, 9, HeightShape.TRAPEZOID, OreAnchor.aboveBottom(-64), OreAnchor.aboveBottom(0), 16)),
    CHROMIUM(Metals.MetalType.CHROMIUM, new BaseOreConfig("rare", 4, 0.1f, 6, HeightShape.TRAPEZOID, OreAnchor.aboveBottom(-40), OreAnchor.absolute(16)), new BaseOreConfig("normal", 8, 0.25f, 9, HeightShape.TRAPEZOID, OreAnchor.aboveBottom(-24), OreAnchor.absolute(64)), new BaseOreConfig("deep", 5, 0.3f, 10, HeightShape.TRAPEZOID, OreAnchor.aboveBottom(-80), OreAnchor.absolute(-64))),
    CADMIUM(Metals.MetalType.CADMIUM, new BaseOreConfig("normal", 8, 0.25f, 9, HeightShape.TRAPEZOID, OreAnchor.aboveBottom(-24), OreAnchor.absolute(64)), new BaseOreConfig("abundant", 15, 0.0f, 7, HeightShape.UNIFORM, OreAnchor.aboveBottom(-64), OreAnchor.absolute(-32)), new BaseOreConfig("deep", 6, 0.2f, 5, HeightShape.TRAPEZOID, OreAnchor.aboveBottom(-96), OreAnchor.absolute(-64))),
    NICKEL(Metals.MetalType.NICKEL, new BaseOreConfig("upper", 65, 0.0, 7, HeightShape.TRAPEZOID, OreAnchor.absolute(80), OreAnchor.absolute(384), 8), new BaseOreConfig("middle", 6, 0.0f, 9, HeightShape.TRAPEZOID, OreAnchor.absolute(-32), OreAnchor.absolute(56)), new BaseOreConfig("small", 8, 0.0f, 4, HeightShape.UNIFORM, OreAnchor.absolute(0), OreAnchor.absolute(64))),
    SILVER(Metals.MetalType.SILVER, new BaseOreConfig("normal", 8, 0.25f, 9, HeightShape.TRAPEZOID, OreAnchor.aboveBottom(-24), OreAnchor.absolute(64)), new BaseOreConfig("abundant", 16, 0.0f, 7, HeightShape.UNIFORM, OreAnchor.aboveBottom(-64), OreAnchor.absolute(16)), new BaseOreConfig("rich", 12, 0.1f, 10, HeightShape.TRAPEZOID, OreAnchor.absolute(-64), OreAnchor.absolute(-32))),
    LEAD(Metals.MetalType.LEAD, new BaseOreConfig("normal", 8, 0.25f, 9, HeightShape.TRAPEZOID, OreAnchor.aboveBottom(-24), OreAnchor.absolute(64)), new BaseOreConfig("abundant", 15, 0.1f, 7, HeightShape.UNIFORM, OreAnchor.aboveBottom(-64), OreAnchor.absolute(-32)), new BaseOreConfig("deep", 10, 0.3f, 6, HeightShape.TRAPEZOID, OreAnchor.aboveBottom(-80), OreAnchor.absolute(-48)));

    public static Codec<OreType> CODEC;
    private final List<BaseOreConfig> baseConfigs;
    private final Metals.MetalType metalType;

    private OreType(Metals.MetalType metalType, BaseOreConfig ... configs) {
        this.metalType = metalType;
        this.baseConfigs = List.of(configs);
    }

    public Metals.MetalType getMetalType() {
        return this.metalType;
    }

    public List<BaseOreConfig> getBaseConfigs() {
        return this.baseConfigs;
    }

    public static OreType get(Metals.MetalType resource) {
        for (OreType ore : OreType.values()) {
            if (resource != ore.metalType) continue;
            return ore;
        }
        return null;
    }

    @NotNull
    public String m_7912_() {
        return this.metalType.m_6082_();
    }

    static {
        CODEC = StringRepresentable.m_216439_(OreType::values);
    }

    public record OreVeinType(OreType type, int index) {
        public static final Codec<OreVeinType> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CODEC.fieldOf("type").forGetter(config -> config.type), (App)Codec.INT.fieldOf("index").forGetter(config -> config.index)).apply((Applicative)builder, OreVeinType::new));

        public OreVeinType {
            if (index < 0 || index >= type.getBaseConfigs().size()) {
                throw new IndexOutOfBoundsException("Vein Type index out of range: " + index);
            }
        }

        public String name() {
            return "ore_" + this.type.m_7912_() + "_" + this.type.getBaseConfigs().get(this.index).name();
        }
    }
}

