/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.common.util;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import leaf.cosmere.api.CosmereAPI;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

public class TaskQueueManager {
    public static void submitTask(ResourceLocation id, Task task) {
        Impl.TASKS.add((Pair<ResourceLocation, Task>)Pair.of((Object)id, (Object)task));
    }

    public static void submitDelayedTask(ResourceLocation id, int delay, Task task) {
        Impl.TASKS.add((Pair<ResourceLocation, Task>)Pair.of((Object)id, (Object)new DelayedTask(delay, task)));
    }

    @Mod.EventBusSubscriber(modid="cosmere", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Impl {
        private static final Queue<Pair<ResourceLocation, Task>> TASKS = new ArrayDeque<Pair<ResourceLocation, Task>>();

        @SubscribeEvent
        public static void tick(TickEvent.ServerTickEvent e) {
            Iterator it = TASKS.iterator();
            Pair current = null;
            while (it.hasNext()) {
                current = (Pair)it.next();
                try {
                    if (!((Task)current.getRight()).execute().isCompleted()) continue;
                    it.remove();
                }
                catch (Exception ex) {
                    CosmereAPI.logger.error("An exception occurred while running a ticking task with ID {}. It will be terminated.", current.getLeft());
                    it.remove();
                    ex.printStackTrace();
                }
            }
        }

        @SubscribeEvent
        public static void stopped(ServerStoppedEvent e) {
            TASKS.clear();
        }

        @SubscribeEvent
        public static void started(ServerStartedEvent e) {
            TASKS.clear();
        }
    }

    private static class DelayedTask
    implements Task {
        private int delay;
        private Task task;

        private DelayedTask(int delay, Task task) {
            this.delay = delay;
            this.task = task;
        }

        @Override
        public Status execute() {
            if (this.delay-- > 0) {
                return Status.RUNNING;
            }
            return this.task.execute();
        }
    }

    @FunctionalInterface
    public static interface Task {
        public Status execute();
    }

    public static class OneOffTask
    implements Task {
        private final Runnable task;

        public OneOffTask(Runnable task) {
            this.task = task;
        }

        @Override
        public Status execute() {
            this.task.run();
            return Status.COMPLETED;
        }
    }

    public static enum Status {
        RUNNING,
        COMPLETED;


        public boolean isCompleted() {
            return this == COMPLETED;
        }
    }
}

