/*
 * Decompiled with CFR 0.152.
 */
package net.phoenix.chatemojis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.phoenix.chatemojis.Util;
import net.phoenix.chatemojis.chatemojis.CustomAnimatedEmoji;
import net.phoenix.chatemojis.chatemojis.CustomEmoji;
import net.phoenix.chatemojis.chatemojis.DefaultEmoji;
import net.phoenix.chatemojis.chatemojis.Emoji;

@Mod(modid="chatemojis", acceptedMinecraftVersions="[1.8.9]")
public class ChatEmojis {
    public static final String MOD_ID = "chatemojis";
    public static final Map<String, Emoji> REGISTRY = new HashMap<String, Emoji>();
    public static Minecraft mc = null;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        System.out.println("Loading ChatEmojis mod");
        mc = Minecraft.func_71410_x();
        this.registerEmojis();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            CustomAnimatedEmoji.clearCache();
        }
    }

    private void registerEmojis() {
        try {
            String line;
            System.out.println("Loading default emojis");
            ResourceLocation manifest = new ResourceLocation(MOD_ID, "textures/emojis/emoji_manifest.txt");
            InputStream input = mc.func_110442_L().func_110536_a(manifest).func_110527_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((line = reader.readLine()) != null) {
                try {
                    ResourceLocation emojiLoc = new ResourceLocation(MOD_ID, "textures/emojis/images/" + line);
                    IResource resource = mc.func_110442_L().func_110536_a(emojiLoc);
                    DefaultEmoji emoji = DefaultEmoji.fromResource(resource);
                    if (emoji == null) continue;
                    String key = line.replace(".png", "");
                    REGISTRY.put(key, emoji);
                }
                catch (FileNotFoundException emojiLoc) {}
            }
            reader.close();
            File emojiFolder = new File(Minecraft.func_71410_x().field_71412_D, MOD_ID);
            emojiFolder.mkdirs();
            File[] files = emojiFolder.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isFile() && file.getName().endsWith(".gif")) {
                        System.out.println("Loading custom animated emoji: " + file.getName());
                        REGISTRY.put(Util.removeExtension(file.getName()), CustomAnimatedEmoji.fromResource(file));
                        continue;
                    }
                    System.out.println("Attempting to load file: " + file.getName());
                    CustomEmoji customEmoji = CustomEmoji.fromResource(file);
                    if (customEmoji == null) {
                        System.out.println("Couldn't load file: " + file.getName());
                        continue;
                    }
                    REGISTRY.put(Util.removeExtension(file.getName()), customEmoji);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

