/*
 * Decompiled with CFR 0.152.
 */
package net.phoenix.chatemojis;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class Util {
    public static String removeExtension(String s) {
        String separator = System.getProperty("file.separator");
        int lastSeparatorIndex = s.lastIndexOf(separator);
        String filename = lastSeparatorIndex == -1 ? s : s.substring(lastSeparatorIndex + 1);
        int extensionIndex = filename.lastIndexOf(".");
        if (extensionIndex == -1) {
            return filename;
        }
        return filename.substring(0, extensionIndex);
    }

    public static List<BufferedImage> getAllFrames(File gifFile) throws IOException {
        ArrayList<BufferedImage> frames = new ArrayList<BufferedImage>();
        ImageInputStream imageStream = ImageIO.createImageInputStream(gifFile);
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("gif");
        if (!readers.hasNext()) {
            throw new IOException("No suitable ImageReader found for GIF format.");
        }
        ImageReader gifReader = readers.next();
        gifReader.setInput(imageStream);
        int frameCount = gifReader.getNumImages(true);
        for (int i = 0; i < frameCount; ++i) {
            BufferedImage frame = gifReader.read(i);
            frames.add(frame);
        }
        return frames;
    }
}

