/*
 * Decompiled with CFR 0.152.
 */
package net.phoenix.chatemojis.mixin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.phoenix.chatemojis.ChatEmojis;
import net.phoenix.chatemojis.chatemojis.Emoji;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FontRenderer.class})
public abstract class FontRendererMixin {
    @Unique
    private static final Pattern EMOJI_PATTERN = Pattern.compile(":([a-zA-Z0-9_]+):");

    @Shadow
    protected abstract int func_180455_b(String var1, float var2, float var3, int var4, boolean var5);

    @Shadow
    protected abstract void func_78265_b();

    @Shadow
    protected abstract void enableAlpha();

    @Inject(method={"drawString(Ljava/lang/String;FFIZ)I"}, at={@At(value="HEAD")}, cancellable=true)
    public void drawStringInject(String text, float x, float y, int color, boolean dropShadow, CallbackInfoReturnable<Integer> cir) {
        if (!text.contains(":") || !EMOJI_PATTERN.matcher(text).find()) {
            return;
        }
        int cursorX = (int)x;
        int lastMatchEnd = 0;
        Matcher matcher = EMOJI_PATTERN.matcher(text);
        FontRenderer fontRenderer = (FontRenderer)this;
        while (matcher.find()) {
            this.func_78265_b();
            this.enableAlpha();
            String beforeEmoji = text.substring(lastMatchEnd, matcher.start());
            if (dropShadow) {
                this.func_180455_b(beforeEmoji, cursorX + 1, y + 1.0f, color, true);
                this.func_180455_b(beforeEmoji, cursorX, y, color, false);
            } else {
                this.func_180455_b(beforeEmoji, cursorX, y, color, false);
            }
            int width = fontRenderer.func_78256_a(beforeEmoji);
            cursorX += width;
            String emojiKey = matcher.group(1);
            Emoji emoji = ChatEmojis.REGISTRY.get(emojiKey);
            if (emoji != null) {
                float texWidth = emoji.getTexWidth();
                float texHeight = emoji.getTexHeight();
                float scale = 8.0f / texHeight;
                float brightness = 1.0f;
                emoji.bindTexture(cursorX, (int)y);
                this.chatEmojis$render(cursorX, y, texWidth, texHeight, scale, brightness);
                cursorX += (int)(8.0f / texHeight * texWidth);
            } else {
                String notFoundEmoji = ":" + emojiKey + ":";
                if (dropShadow) {
                    this.func_180455_b(notFoundEmoji, cursorX + 1, y + 1.0f, color, true);
                    this.func_180455_b(notFoundEmoji, cursorX, y, color, false);
                } else {
                    this.func_180455_b(notFoundEmoji, cursorX, y, color, false);
                }
                cursorX += fontRenderer.func_78256_a(notFoundEmoji);
            }
            lastMatchEnd = matcher.end();
        }
        if (lastMatchEnd < text.length()) {
            this.func_78265_b();
            this.enableAlpha();
            String remaining = text.substring(lastMatchEnd);
            if (dropShadow) {
                this.func_180455_b(remaining, cursorX + 1, y + 1.0f, color, true);
                this.func_180455_b(remaining, cursorX, y, color, false);
            } else {
                this.func_180455_b(remaining, cursorX, y, color, false);
            }
            cursorX += ChatEmojis.mc.field_71466_p.func_78256_a(remaining);
        }
        cir.setReturnValue(cursorX);
    }

    @Unique
    private void chatEmojis$render(float x, float y, float width, float height, float scale, float brightness) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)height, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)width, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)width, (float)height, (float)0.0f);
        GL11.glEnd();
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
    }
}

