/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.MasaGadget.util;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.plusls.MasaGadget.SharedConstants;
import com.plusls.MasaGadget.api.event.DisconnectListener;
import com.plusls.MasaGadget.game.Configs;
import com.plusls.MasaGadget.mixin.accessor.AccessorAbstractMinecartContainer;
import com.plusls.MasaGadget.mixin.accessor.AccessorAbstractVillager;
import com.plusls.MasaGadget.mixin.accessor.AccessorLivingEntity;
import com.plusls.MasaGadget.mixin.accessor.AccessorVillager;
import com.plusls.MasaGadget.mixin.accessor.AccessorZombieVillager;
import com.plusls.MasaGadget.util.PcaSyncUtil;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1496;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1693;
import net.minecraft.class_1799;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3988;
import net.minecraft.class_634;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.compat.minecraft.resources.ResourceLocationCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.world.SimpleContainerCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.world.entity.player.PlayerCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.world.level.LevelCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.world.level.block.BlockEntityCompat;
import top.hendrixshen.magiclib.util.minecraft.NetworkUtil;

public class PcaSyncProtocol {
    private static final String NAMESPACE = "pca";
    public static final class_2960 SYNC_BLOCK_ENTITY = PcaSyncProtocol.id("sync_block_entity");
    public static final class_2960 SYNC_ENTITY = PcaSyncProtocol.id("sync_entity");
    public static final class_2960 CANCEL_SYNC_REQUEST_BLOCK_ENTITY = PcaSyncProtocol.id("cancel_sync_block_entity");
    public static final class_2960 CANCEL_SYNC_ENTITY = PcaSyncProtocol.id("cancel_sync_entity");
    public static final class_2960 ENABLE_PCA_SYNC_PROTOCOL = PcaSyncProtocol.id("enable_pca_sync_protocol");
    public static final class_2960 DISABLE_PCA_SYNC_PROTOCOL = PcaSyncProtocol.id("disable_pca_sync_protocol");
    public static final class_2960 UPDATE_ENTITY = PcaSyncProtocol.id("update_entity");
    public static final class_2960 UPDATE_BLOCK_ENTITY = PcaSyncProtocol.id("update_block_entity");
    public static boolean enable = false;
    private static class_2338 lastBlockPos = null;
    private static int lastEntityId = -1;

    @NotNull
    private static class_2960 id(String path) {
        return ResourceLocationCompat.fromNamespaceAndPath((String)NAMESPACE, (String)path);
    }

    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ENABLE_PCA_SYNC_PROTOCOL, PcaSyncProtocol::enablePcaSyncProtocolHandler);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)DISABLE_PCA_SYNC_PROTOCOL, PcaSyncProtocol::disablePcaSyncProtocolHandler);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)UPDATE_ENTITY, PcaSyncProtocol::updateEntityHandler);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)UPDATE_BLOCK_ENTITY, PcaSyncProtocol::updateBlockEntityHandler);
        MagicLib.getInstance().getEventManager().register(DisconnectListener.class, PcaSyncProtocol::onDisconnect);
    }

    private static void onDisconnect() {
        SharedConstants.getLogger().info("pcaSyncProtocol onDisconnect.");
        enable = false;
    }

    private static void enablePcaSyncProtocolHandler(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        if (!class_310.method_1551().method_1496()) {
            SharedConstants.getLogger().info("pcaSyncProtocol enable.");
            enable = true;
        }
    }

    public static void disablePcaSyncProtocolHandler(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        if (!class_310.method_1551().method_1496()) {
            SharedConstants.getLogger().info("pcaSyncProtocol disable.");
            enable = false;
        }
    }

    public static void updateEntityHandler(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        PlayerCompat playerCompat = PlayerCompat.of((class_1657)player);
        LevelCompat levelCompat = playerCompat.getLevelCompat();
        class_1937 level = (class_1937)levelCompat.get();
        if (!levelCompat.getDimensionLocation().equals((Object)buf.method_10810())) {
            return;
        }
        int entityId = buf.readInt();
        class_2487 tag = NetworkUtil.readNbt((class_2540)buf);
        class_1297 entity = level.method_8469(entityId);
        if (entity != null) {
            SharedConstants.getLogger().debug("update entity!");
            assert (tag != null);
            if (entity instanceof class_1308 && tag.method_10577("PersistenceRequired")) {
                ((class_1308)entity).method_5971();
            }
            if (entity instanceof class_1693) {
                class_2371<class_1799> itemStacks = ((AccessorAbstractMinecartContainer)entity).masa_gadget_mod$getItemStacks();
                itemStacks.clear();
                class_1262.method_5429((class_2487)tag, itemStacks);
            }
            if (entity instanceof class_3988) {
                ((class_3988)entity).method_35199().method_5448();
                SimpleContainerCompat.of((class_1277)((class_3988)entity).method_35199()).fromTag(tag.method_10554("Inventory", 10));
                ((AccessorAbstractVillager)entity).masa_gadget_mod$setOffers(new class_1916(tag.method_10562("Offers")));
                if (entity instanceof class_1646) {
                    ((AccessorVillager)entity).masa_gadget_mod$setNumberOfRestocksToday(tag.method_10550("RestocksToday"));
                    ((AccessorVillager)entity).masa_gadget_mod$setLastRestockGameTime(tag.method_10537("LastRestock"));
                    ((AccessorLivingEntity)entity).masa_gadget_mod$setBrain(((AccessorLivingEntity)entity).masa_gadget_mod$makeBrain(new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("Brain"))));
                }
            }
            if (entity instanceof class_1496) {
                entity.method_5651(tag);
            }
            if (entity instanceof class_1657) {
                class_1657 playerEntity = (class_1657)entity;
                PlayerCompat.of((class_1657)playerEntity).getInventory().method_7397(tag.method_10554("Inventory", 10));
                if (tag.method_10573("EnderItems", 9)) {
                    playerEntity.method_7274().method_7659(tag.method_10554("EnderItems", 10));
                }
            }
            if (entity instanceof class_1641 && tag.method_10573("ConversionTime", 99) && tag.method_10550("ConversionTime") > -1) {
                ((AccessorZombieVillager)entity).masa_gadget_mod$startConverting(tag.method_25928("ConversionPlayer") ? tag.method_25926("ConversionPlayer") : null, tag.method_10550("ConversionTime"));
            }
        }
    }

    public static void updateBlockEntityHandler(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        LevelCompat levelCompat = PlayerCompat.of((class_1657)player).getLevelCompat();
        class_1937 level = (class_1937)levelCompat.get();
        if (!levelCompat.getDimensionLocation().equals((Object)buf.method_10810())) {
            return;
        }
        class_2338 pos = buf.method_10811();
        class_2487 tag = NetworkUtil.readNbt((class_2540)buf);
        class_2586 blockEntity = level.method_8321(pos);
        if (Configs.saveInventoryToSchematicInServer.getBooleanValue() && pos.equals((Object)PcaSyncUtil.lastUpdatePos)) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)SharedConstants.tr("message.loadInventoryToLocalSuccess"), (Object[])new Object[0]);
            PcaSyncUtil.lastUpdatePos = null;
        }
        if (blockEntity != null) {
            SharedConstants.getLogger().debug("update blockEntity!");
            BlockEntityCompat.of((class_2586)blockEntity).load(Objects.requireNonNull(tag));
        }
    }

    public static void syncBlockEntity(class_2338 pos) {
        if (lastBlockPos != null && lastBlockPos.equals((Object)pos)) {
            return;
        }
        SharedConstants.getLogger().debug("syncBlockEntity: {}", (Object)pos);
        lastBlockPos = pos;
        lastEntityId = -1;
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(pos);
        ClientPlayNetworking.send((class_2960)SYNC_BLOCK_ENTITY, (class_2540)buf);
    }

    public static void syncEntity(int entityId) {
        if (lastEntityId != -1 && lastEntityId == entityId) {
            return;
        }
        SharedConstants.getLogger().debug("syncEntity: {}", (Object)entityId);
        lastEntityId = entityId;
        lastBlockPos = null;
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_53002(entityId);
        ClientPlayNetworking.send((class_2960)SYNC_ENTITY, (class_2540)buf);
    }

    public static void cancelSyncBlockEntity() {
        if (lastBlockPos == null) {
            return;
        }
        lastBlockPos = null;
        SharedConstants.getLogger().debug("cancelSyncBlockEntity.");
        class_2540 buf = new class_2540(Unpooled.buffer());
        ClientPlayNetworking.send((class_2960)CANCEL_SYNC_REQUEST_BLOCK_ENTITY, (class_2540)buf);
    }

    public static void cancelSyncEntity() {
        if (lastEntityId == -1) {
            return;
        }
        lastEntityId = -1;
        SharedConstants.getLogger().debug("cancelSyncEntity.");
        class_2540 buf = new class_2540(Unpooled.buffer());
        ClientPlayNetworking.send((class_2960)CANCEL_SYNC_ENTITY, (class_2540)buf);
    }
}

