/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.MasaGadget.impl.generic;

import com.google.common.collect.Sets;
import com.plusls.MasaGadget.impl.mod_tweak.tweakeroo.inventoryPreviewSupportSelect.InventoryOverlayRenderHandler;
import com.plusls.MasaGadget.util.InventoryPreviewSyncDataClientOnlyUtil;
import com.plusls.MasaGadget.util.InventoryPreviewSyncDataUtil;
import com.plusls.MasaGadget.util.MiscUtil;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.config.Hotkeys;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.compat.minecraft.util.ProfilerCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.world.entity.EntityCompat;
import top.hendrixshen.magiclib.util.collect.ValueContainer;

public class HitResultHandler {
    private static final HitResultHandler instance = new HitResultHandler();
    private final Set<HitResultCallback> hitCallbacks = Sets.newHashSet();
    private boolean lastInventoryPreviewStatus = false;
    @Nullable
    private class_239 lastHitResult = null;
    @Nullable
    private Object lastHitBlockEntity = null;

    @ApiStatus.Internal
    public void init() {
        ClientTickEvents.END_CLIENT_TICK.register(minecraft -> HitResultHandler.getInstance().endClientTickCallback());
        if (MagicLib.getInstance().getCurrentPlatform().isModLoaded("tweakeroo")) {
            this.registerOnHitCallback(InventoryPreviewSyncDataUtil::onHitCallback);
            this.registerOnHitCallback(InventoryPreviewSyncDataClientOnlyUtil::onHitCallback);
            this.registerOnHitCallback(InventoryOverlayRenderHandler::onHitCallback);
        }
    }

    public ValueContainer<Object> getLastHitBlockEntity() {
        return ValueContainer.ofNullable((Object)this.lastHitBlockEntity);
    }

    public ValueContainer<class_239> getLastHitResult() {
        return ValueContainer.ofNullable((Object)this.lastHitResult);
    }

    public ValueContainer<class_1297> getCameraEntity() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return null;
        }
        class_746 player = mc.field_1724;
        class_1297 cameraEntity = mc.method_1560();
        if (!MagicLib.getInstance().getCurrentPlatform().isModLoaded("tweakeroo") || !FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue() || cameraEntity == null) {
            cameraEntity = player;
        }
        return ValueContainer.of((Object)cameraEntity);
    }

    public ValueContainer<class_1297> getHitEntity() {
        class_239 hitResult = this.lastHitResult;
        if (hitResult == null) {
            return ValueContainer.empty();
        }
        if (hitResult.method_17783() != class_239.class_240.field_1331) {
            return ValueContainer.empty();
        }
        return ValueContainer.of((Object)((class_3966)hitResult).method_17782());
    }

    public ValueContainer<class_239> getHitResult() {
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (level == null) {
            return ValueContainer.empty();
        }
        ValueContainer<class_1297> cameraEntity = this.getCameraEntity();
        if (cameraEntity.isEmpty()) {
            return ValueContainer.empty();
        }
        try {
            class_239 hitResult = this.getRayTraceFromEntity((class_1937)level, (class_1297)cameraEntity.get(), false);
            if (hitResult.method_17783() == class_239.class_240.field_1333) {
                return ValueContainer.empty();
            }
            if (hitResult.method_17783() == class_239.class_240.field_1331) {
                class_3966 entityHitResult = (class_3966)hitResult;
                hitResult = new class_3966(MiscUtil.getBestEntity(entityHitResult.method_17782()), entityHitResult.method_17784());
            }
            return ValueContainer.of((Object)hitResult);
        }
        catch (ConcurrentModificationException e) {
            return ValueContainer.empty();
        }
    }

    public ValueContainer<class_2338> getHitBlockPos() {
        class_239 hitResult = this.lastHitResult;
        if (hitResult == null) {
            return ValueContainer.empty();
        }
        if (hitResult.method_17783() != class_239.class_240.field_1332) {
            return ValueContainer.empty();
        }
        return ValueContainer.of((Object)((class_3965)hitResult).method_17777());
    }

    public class_239 getRayTraceFromEntity(class_1937 worldIn, class_1297 entityIn, boolean useLiquids) {
        double reach = 5.0;
        return this.getRayTraceFromEntity(worldIn, entityIn, useLiquids, reach);
    }

    public class_239 getRayTraceFromEntity(class_1937 worldIn, class_1297 entityIn, boolean useLiquids, double range) {
        class_3959.class_242 fluidMode;
        class_243 rangedLookRot;
        class_243 lookVec;
        EntityCompat entityInCompat = EntityCompat.of((class_1297)entityIn);
        class_243 eyesVec = new class_243(entityInCompat.getX(), entityInCompat.getY() + (double)entityIn.method_5751(), entityInCompat.getZ());
        class_3959 context = new class_3959(eyesVec, lookVec = eyesVec.method_1019(rangedLookRot = entityIn.method_5828(1.0f).method_1021(range)), class_3959.class_3960.field_17558, fluidMode = useLiquids ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348, entityIn);
        class_3965 result = worldIn.method_17742(context);
        if (result == null) {
            result = class_3965.method_17778((class_243)class_243.field_1353, (class_2350)class_2350.field_11036, (class_2338)class_2338.field_10980);
        }
        class_238 bb = entityIn.method_5829().method_1009(rangedLookRot.field_1352, rangedLookRot.field_1351, rangedLookRot.field_1350).method_1009(1.0, 1.0, 1.0);
        List list = worldIn.method_8335(entityIn, bb);
        double closest = result.method_17783() == class_239.class_240.field_1332 ? eyesVec.method_1022(result.method_17784()) : Double.MAX_VALUE;
        Optional entityTrace = Optional.empty();
        class_1297 targetEntity = null;
        for (class_1297 entity : list) {
            double distance;
            bb = entity.method_5829();
            Optional traceTmp = bb.method_992(lookVec, eyesVec);
            if (!traceTmp.isPresent() || !((distance = eyesVec.method_1022((class_243)traceTmp.get())) <= closest)) continue;
            targetEntity = entity;
            entityTrace = traceTmp;
            closest = distance;
        }
        if (targetEntity != null) {
            result = new class_3966(targetEntity, (class_243)entityTrace.get());
        }
        return result;
    }

    public boolean getLastInventoryPreviewStatus() {
        return this.lastHitResult != null && this.lastInventoryPreviewStatus;
    }

    public void endClientTickCallback() {
        ValueContainer<class_2338> pos;
        class_3695 profiler = ProfilerCompat.get();
        class_1937 level = WorldUtils.getBestWorld((class_310)class_310.method_1551());
        if (level == null) {
            return;
        }
        boolean currentStatus = false;
        if (MagicLib.getInstance().getCurrentPlatform().isModLoaded("tweakeroo")) {
            currentStatus = Hotkeys.INVENTORY_PREVIEW.getKeybind().isKeybindHeld();
        }
        profiler.method_15396("HitResultUtil.getHitResult");
        this.lastHitResult = (class_239)this.getHitResult().orElse(null);
        profiler.method_15407();
        this.lastHitBlockEntity = null;
        if (this.lastHitResult != null && this.lastHitResult.method_17783() == class_239.class_240.field_1332 && currentStatus && (pos = this.getHitBlockPos()).isPresent()) {
            profiler.method_15396("MiscUtil.getContainer");
            this.lastHitBlockEntity = MiscUtil.getContainer(level, (class_2338)pos.get());
            profiler.method_15407();
            if (this.lastHitBlockEntity == null) {
                profiler.method_15396("world.getChunkAt");
                class_2818 levelChunk = level.method_8500((class_2338)pos.get());
                profiler.method_15407();
                if (levelChunk != null) {
                    profiler.method_15396("levelChunk.getBlockEntity");
                    this.lastHitBlockEntity = levelChunk.method_8321((class_2338)pos.get());
                    profiler.method_15407();
                }
            }
        }
        profiler.method_15396("MiscUtil: run callbacks");
        for (HitResultCallback callback : this.hitCallbacks) {
            callback.onHit(this.lastHitResult, this.lastInventoryPreviewStatus, currentStatus != this.lastInventoryPreviewStatus);
        }
        profiler.method_15407();
        this.lastInventoryPreviewStatus = currentStatus;
    }

    public void registerOnHitCallback(HitResultCallback callback) {
        this.hitCallbacks.add(callback);
    }

    @Generated
    public static HitResultHandler getInstance() {
        return instance;
    }

    @FunctionalInterface
    public static interface HitResultCallback {
        public void onHit(@Nullable class_239 var1, boolean var2, boolean var3);
    }
}

