/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.MasaGadget.mixin.mod_tweak.malilib.optimizeConfigWidgetSearch;

import com.google.common.collect.ImmutableList;
import com.plusls.MasaGadget.game.Configs;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigResettable;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.widgets.WidgetConfigOption;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptionsBase;
import java.util.List;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.hendrixshen.magiclib.api.dependency.DependencyType;
import top.hendrixshen.magiclib.api.dependency.annotation.CompositeDependencies;
import top.hendrixshen.magiclib.api.dependency.annotation.Dependencies;
import top.hendrixshen.magiclib.api.dependency.annotation.Dependency;
import top.hendrixshen.magiclib.api.platform.PlatformType;

@CompositeDependencies(value={@Dependencies(require={@Dependency(value="malilib", versionPredicates={"<0.11.0"}), @Dependency(dependencyType=DependencyType.PLATFORM, platformType=PlatformType.FABRIC_LIKE)}), @Dependencies(require={@Dependency(value="minecraft", versionPredicates={"<1.18-"}), @Dependency(dependencyType=DependencyType.PLATFORM, platformType=PlatformType.FORGE_LIKE)})})
@Mixin(value={WidgetListConfigOptions.class}, remap=false)
public abstract class MixinWidgetListConfigOptions
extends WidgetListConfigOptionsBase<GuiConfigsBase.ConfigOptionWrapper, WidgetConfigOption> {
    public MixinWidgetListConfigOptions(int x, int y, int width, int height, int configWidth) {
        super(x, y, width, height, configWidth);
    }

    @Inject(method={"getEntryStringsForFilter*"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetEntryStringsForFilter(GuiConfigsBase.ConfigOptionWrapper entry, CallbackInfoReturnable<List<String>> cir) {
        if (!Configs.optimizeConfigWidgetSearch.getBooleanValue()) {
            return;
        }
        IConfigBase config = entry.getConfig();
        if (config != null) {
            if (config instanceof IConfigResettable && ((IConfigResettable)config).isModified()) {
                cir.setReturnValue((Object)ImmutableList.of((Object)config.getConfigGuiDisplayName().toLowerCase(), (Object)config.getName().toLowerCase(), (Object)"modified"));
            } else {
                cir.setReturnValue((Object)ImmutableList.of((Object)config.getConfigGuiDisplayName().toLowerCase(), (Object)config.getName().toLowerCase()));
            }
        }
    }

    protected boolean matchesFilter(List<String> entryStrings, String filterText) {
        if (!Configs.optimizeConfigWidgetSearch.getBooleanValue()) {
            return super.matchesFilter(entryStrings, filterText);
        }
        if ((filterText = filterText.toLowerCase()).isEmpty()) {
            return true;
        }
        for (String str : entryStrings) {
            if (!this.matchesFilter(str, filterText)) continue;
            return true;
        }
        return false;
    }
}

