package xyz.venividivivi.weirdequipment.entity;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3857;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import xyz.venividivivi.weirdequipment.block.WallRopeBlock;
import xyz.venividivivi.weirdequipment.item.RopeCoilItem;
import xyz.venividivivi.weirdequipment.registry.WeirdEquipmentBlocks;
import xyz.venividivivi.weirdequipment.registry.WeirdEquipmentEntityTypes;
import xyz.venividivivi.weirdequipment.registry.WeirdEquipmentItems;

public class RopeCoilEntity extends class_3857 {

    // The type of rope thrown is stored as TrackedData, which allows the client to see it and determine which sprite to use
    private static final class_2940<class_1799> STACK = class_2945.method_12791(RopeCoilEntity.class, class_2943.field_13322);
    public boolean isPlacing = false;
    private class_2338 blockPos = null;
    private int i = 0;
    private int count = 0;
    public class_1937 world = method_37908();

    public RopeCoilEntity(class_1937 world, class_1309 owner, RopeCoilItem item) {
        super(WeirdEquipmentEntityTypes.ROPE_COIL.get(), owner, world);
        count = item.count;
        method_5841().method_12784(STACK, new class_1799(item, 1));
        this.method_51502(method_37908());
    }

    public RopeCoilEntity(class_1299<RopeCoilEntity> ropeCoilEntityEntityType, class_1937 world) {
        super(ropeCoilEntityEntityType, world);
        method_5841().method_12784(STACK, new class_1799(WeirdEquipmentItems.SMALL_ROPE_COIL.get(), 1));
    }


    @Override
    protected void method_24920(class_3965 blockHitResult) {
        // Prevents method from being triggered twice
        if (!isPlacing) {
            class_2350 side = blockHitResult.method_17780();
            blockPos = blockHitResult.method_17777().method_10093(side);
            if (world.method_8320(blockPos).method_26215() && side != class_2350.field_11036) {
                class_2680 blockState;
                if (side.method_10166().method_10179())
                    blockState = WeirdEquipmentBlocks.WALL_ROPE.get().method_9564().method_11657(WallRopeBlock.field_11177, side.method_10153());
                else
                    blockState = WeirdEquipmentBlocks.ROPE.get().method_9564();

                if (blockState.method_26184(world, blockPos))
                    world.method_8501(blockPos, blockState);
                else
                    dropItem();

                // Freezes the projectile in place
                this.method_5875(true);
                this.method_7485(0, 0, 0, 0f, 0f);

                count--;

                // Placement of ropes is passed to tick(), which allows them to be placed sequentially instead of all at once
                isPlacing = true;
            } else dropItem();
        }
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {
        world.method_8649(new class_1542(world, method_23317(), method_23318(), method_23321(), method_5841().method_12789(STACK)));
        method_5650(class_5529.field_26999);
    }

    @Override
    public void method_5773() {
        if (i == 2) {
            i = 0;
            if (isPlacing && blockPos != null) {
                if (world.method_8320(blockPos = blockPos.method_10093(class_2350.field_11033)).method_26215() && count > 0) {
                    world.method_8501(blockPos, WeirdEquipmentBlocks.ROPE.get().method_9564());
                    count--;
                } else if (count > 0) {
                    world.method_8649(new class_1542(world, blockPos.method_10263(), blockPos.method_10264() + 1.5, blockPos.method_10260(), new class_1799(WeirdEquipmentItems.ROPE.get(), count)));
                    method_5650(class_5529.field_26999);
                } else {
                    method_5650(class_5529.field_26999);
                }
            }
        } else i++;
        super.method_5773();
    }

    public void dropItem() {
        world.method_8649(new class_1542(world, method_23317(), method_23318(), method_23321(), method_5841().method_12789(STACK)));
        method_5650(class_5529.field_26999);
    }

    // Among other things, this method determines which sprite the projectile uses
    @Override
    protected class_1792 method_16942() {
        return method_5841().method_12789(STACK).method_7909();
    }
}