package xyz.venividivivi.weirdequipment.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1738;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1820;
import net.minecraft.class_1829;
import net.minecraft.class_1834;
import net.minecraft.class_2960;
import net.minecraft.class_3612;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import net.minecraft.item.*;
import xyz.venividivivi.weirdequipment.WeirdEquipment;
import xyz.venividivivi.weirdequipment.item.material.CactusMaterial;
import xyz.venividivivi.weirdequipment.item.material.PumpkinArmorMaterial;
import xyz.venividivivi.weirdequipment.item.*;



public class WeirdEquipmentItems {
    public static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create(WeirdEquipment.MOD_ID, class_7924.field_41197);


    public static final RegistrySupplier<class_1792> JACK_O_HELMET = ITEMS.register("jack_o_helmet", () ->
            new JackOHelmetItem(new PumpkinArmorMaterial(), class_1738.class_8051.field_41934, new class_1792.class_1793().arch$tab(class_7706.field_40202)));

    public static final RegistrySupplier<class_1792> CACTUS_SWORD = ITEMS.register("cactus_sword", () ->
            new CactusSword(new CactusMaterial(), 1, -2f, new class_1792.class_1793().arch$tab(class_7706.field_40202)));
    public static final RegistrySupplier<class_1792> DIRT_SWORD = ITEMS.register("dirt_sword", () ->
            new class_1829(class_1834.field_8922, -3, -2.6f, new class_1792.class_1793().arch$tab(class_7706.field_40202)));

    public static final RegistrySupplier<class_1792> FLINT_AND_SHEARS = ITEMS.register("flint_and_shears", () ->
            new FlintAndShearsItem(new class_1792.class_1793().method_7895(300).arch$tab(class_7706.field_41060)));
    public static final RegistrySupplier<class_1792> SELF_SLINGSHOT = ITEMS.register("self_slingshot", () ->
            new SelfSlingshotItem(new class_1792.class_1793().arch$tab(class_7706.field_41060).maxDamage(350)));

    public static final RegistrySupplier<class_1792> DIAMOND_SHEARS = ITEMS.register("diamond_shears", () ->
            new class_1820(new class_1792.class_1793().method_7895(1000).arch$tab(class_7706.field_41060)));
    public static final RegistrySupplier<class_1792> NETHERITE_TORCH_PICKAXE = ITEMS.register("netherite_torch_pickaxe", () ->
            new NetheriteTorchPickaxeItem(class_1834.field_22033, 1, -2.8f, new class_1792.class_1793().arch$tab(class_7706.field_41060)));

    public static final RegistrySupplier<class_1792> BOTTOMLESS_WATER_BUCKET = ITEMS.register("bottomless_water_bucket", () ->
            new class_1755(class_3612.field_15910, new class_1792.class_1793().arch$tab(class_7706.field_41060).maxCount(1)));

    public static final RegistrySupplier<class_1792> LARGE_LAVA_BUCKET = ITEMS.register("large_lava_bucket", () ->
            new class_1755(class_3612.field_15908, new class_1792.class_1793().arch$tab(class_7706.field_41060).maxDamage(9)));

    public static final RegistrySupplier<class_1792> TORCH_BOW = ITEMS.register("torch_bow", () ->
            new TorchBowItem(new class_1792.class_1793().arch$tab(class_7706.field_41060).maxDamage(384)));

    public static final RegistrySupplier<class_1792> TORCH_CORE = ITEMS.register("torch_core", () ->
            new class_1792(new class_1792.class_1793().arch$tab(class_7706.field_41062)));

    public static final RegistrySupplier<class_1792> ROPE = ITEMS.register("rope", () ->
            new WallHangingBlockItem(WeirdEquipmentBlocks.ROPE.get(), WeirdEquipmentBlocks.WALL_ROPE.get(), new class_1792.class_1793().arch$tab(class_7706.field_40195)));

    public static final RegistrySupplier<class_1792> SMALL_ROPE_COIL = ITEMS.register("small_rope_coil", () ->
            new RopeCoilItem(new class_1792.class_1793().arch$tab(class_7706.field_41060).maxCount(32), 9));
    public static final RegistrySupplier<class_1792> LARGE_ROPE_COIL = ITEMS.register("large_rope_coil", () ->
            new RopeCoilItem(new class_1792.class_1793().arch$tab(class_7706.field_41060).maxCount(32), 18));
    public static final RegistrySupplier<class_1792> XL_ROPE_COIL = ITEMS.register("xl_rope_coil", () ->
            new RopeCoilItem(new class_1792.class_1793().arch$tab(class_7706.field_41060).maxCount(16), 36));

    public static void register() {
        ITEMS.register();
        if (Platform.getEnv().equals(EnvType.CLIENT)) {
            TORCH_BOW.listen((item) -> {
                ItemPropertiesRegistry.register(item, new class_2960("pull"), (itemStack, clientWorld, livingEntity, seed) -> {
                    if (livingEntity == null) {
                        return 0.0F;
                    }
                    return livingEntity.method_6030() != itemStack ? 0.0F : (itemStack.method_7935() - livingEntity.method_6014()) / 20.0F;
                });

                ItemPropertiesRegistry.register(item, new class_2960("pulling"), (itemStack, clientWorld, livingEntity, seed) -> {
                    if (livingEntity == null) {
                        return 0.0F;
                    }
                    return livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0F : 0.0F;
                });
            });
        }
    }
}
