/*
 * Decompiled with CFR 0.152.
 */
package org.notionsmp.dreiMotd;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DreiMotd
extends JavaPlugin
implements Listener,
TabExecutor {
    private MiniMessage miniMessage;
    private List<Map<String, Object>> motds;
    private boolean motdEnabled;

    public void onEnable() {
        this.saveDefaultConfig();
        this.miniMessage = MiniMessage.miniMessage();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("dreimotd").setExecutor((CommandExecutor)this);
        this.getCommand("dreimotd").setTabCompleter((TabCompleter)this);
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.motdEnabled = config.getBoolean("enabled", true);
        this.motds = new ArrayList<Map<String, Object>>();
        ConfigurationSection motdsSection = config.getConfigurationSection("motds");
        if (motdsSection != null) {
            for (String key : motdsSection.getKeys(false)) {
                this.motds.add(motdsSection.getConfigurationSection(key).getValues(true));
            }
        }
        if (this.motds.isEmpty()) {
            Object oldFormat;
            Object object = oldFormat = config.isList("motd") ? config.getStringList("motd") : config.getString("motd");
            if (oldFormat != null) {
                Map<String, String> legacyMotd = Map.of("message", oldFormat, "permission", "");
                this.motds.add(legacyMotd);
            }
        }
        this.saveConfig();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.motdEnabled) {
            return;
        }
        this.sendMotd(event.getPlayer());
    }

    private void sendMotd(Player player) {
        String playerName = player.getName();
        for (Map<String, Object> motd : this.motds) {
            String permission = (String)motd.getOrDefault("permission", "");
            if (!permission.isEmpty() && !player.hasPermission(permission)) continue;
            Object message = motd.get("message");
            if (message instanceof List) {
                for (String line : (List)message) {
                    this.sendFormattedMessage(player, line);
                }
                continue;
            }
            if (!(message instanceof String)) continue;
            this.sendFormattedMessage(player, (String)message);
        }
    }

    private void sendFormattedMessage(Player player, String message) {
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        player.sendMessage(this.miniMessage.deserialize(message, new TagResolver[]{Placeholder.unparsed((String)"player", (String)player.getName()), Placeholder.unparsed((String)"displayname", (String)((String)this.miniMessage.serialize(player.displayName()))), Placeholder.unparsed((String)"world", (String)player.getWorld().getName()), Placeholder.unparsed((String)"online_players", (String)String.valueOf(Bukkit.getOnlinePlayers().size())), Placeholder.unparsed((String)"max_players", (String)String.valueOf(Bukkit.getMaxPlayers())), Placeholder.unparsed((String)"server_name", (String)Bukkit.getServer().getName()), Placeholder.unparsed((String)"server_version", (String)Bukkit.getServer().getVersion()), Placeholder.unparsed((String)"time", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss"))), Placeholder.unparsed((String)"date", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")))}));
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            this.showHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("dreimotd.reload")) {
                    sender.sendMessage(this.miniMessage.deserialize((Object)"<red>No permission!</red>"));
                    return true;
                }
                this.reloadConfig();
                this.loadConfig();
                sender.sendMessage(this.miniMessage.deserialize((Object)"<green>Config reloaded!</green>"));
                return true;
            }
            case "test": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.miniMessage.deserialize((Object)"<red>Only players can test!</red>"));
                    return true;
                }
                if (!sender.hasPermission("dreimotd.test")) {
                    sender.sendMessage(this.miniMessage.deserialize((Object)"<red>No permission!</red>"));
                    return true;
                }
                this.testMotd((Player)sender);
                return true;
            }
            case "list": {
                if (!sender.hasPermission("dreimotd.list")) {
                    sender.sendMessage(this.miniMessage.deserialize((Object)"<red>No permission!</red>"));
                    return true;
                }
                this.listMotds(sender);
                return true;
            }
        }
        this.showHelp(sender);
        return true;
    }

    private void listMotds(CommandSender sender) {
        sender.sendMessage(this.miniMessage.deserialize((Object)"<gradient:gold:yellow>DreiMotd List</gradient>"));
        for (int i = 0; i < this.motds.size(); ++i) {
            Object preview;
            Map<String, Object> motd = this.motds.get(i);
            String permission = (String)motd.getOrDefault("permission", "none");
            Object object = preview = motd.get("message") instanceof List ? ((List)motd.get("message")).get(0).toString() : motd.get("message").toString();
            if (((String)preview).length() > 30) {
                preview = ((String)preview).substring(0, 27) + "...";
            }
            sender.sendMessage(this.miniMessage.deserialize((Object)("<gray>#" + (i + 1) + "</gray> - <white>" + (String)preview + "</white>\n  <gray>Permission: " + permission + "</gray>")));
        }
    }

    private void testMotd(Player player) {
        player.sendMessage(this.miniMessage.deserialize((Object)"<gradient:gold:yellow>Testing MOTD...</gradient>"));
        this.sendMotd(player);
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage(this.miniMessage.deserialize((Object)("<gradient:gold:yellow>DreiMotd Help</gradient>\n<gray>/dreimotd reload</gray> - Reload config\n<gray>/dreimotd test</gray> - Test MOTD\n" + (sender.hasPermission("dreimotd.list") ? "<gray>/dreimotd list</gray> - List all MOTDs\n" : ""))));
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if (sender.hasPermission("dreimotd.reload")) {
                completions.add("reload");
            }
            if (sender.hasPermission("dreimotd.test") && sender instanceof Player) {
                completions.add("test");
            }
            if (sender.hasPermission("dreimotd.list")) {
                completions.add("list");
            }
            return completions;
        }
        return new ArrayList<String>();
    }
}

