/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.addon;

import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import io.github.zhengzhengyiyi.gui.EditorScreen;
import java.util.ArrayDeque;
import java.util.Deque;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class UndoRedoEntrypoint
implements ApiEntrypoint {
    private boolean enabled = true;
    private EditorScreen editor;
    private Deque<String> undoStack = new ArrayDeque<String>();
    private Deque<String> redoStack = new ArrayDeque<String>();
    private String currentText = "";
    private boolean isUndoing = false;
    private boolean isRedoing = false;
    private static final int MAX_HISTORY = 100;

    @Override
    public void init() {
    }

    @Override
    public void onEditerOpen(EditorScreen editor) {
        this.editor = editor;
        this.resetStacks();
        if (editor.getTextWidget() != null) {
            this.currentText = editor.getTextWidget().getText();
            this.saveState();
        }
    }

    @Override
    public void onEditerClose(EditorScreen editor) {
        this.editor = null;
        this.resetStacks();
    }

    @Override
    public class_1269 onMouseDown(int x, int y) {
        return class_1269.field_5811;
    }

    @Override
    public void onMouseScroll() {
    }

    @Override
    public class_1269 onType(int keyCode, int scanCode, int modifiers) {
        if (!this.enabled || this.editor == null || this.editor.getTextWidget() == null) {
            return class_1269.field_5811;
        }
        if (keyCode == 90 && class_437.method_25441()) {
            if (class_437.method_25442()) {
                this.performRedo();
            } else {
                this.performUndo();
            }
            return class_1269.field_5814;
        }
        if (keyCode == 89 && class_437.method_25441()) {
            this.performRedo();
            return class_1269.field_5814;
        }
        this.checkTextChange();
        return class_1269.field_5811;
    }

    @Override
    public class_1269 onCharTyped(char chr, int modifiers) {
        if (!this.enabled || this.editor == null || this.editor.getTextWidget() == null) {
            return class_1269.field_5811;
        }
        this.checkTextChange();
        return class_1269.field_5811;
    }

    @Override
    public void renderButton(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void checkTextChange() {
        if (this.isUndoing || this.isRedoing) {
            return;
        }
        String newText = this.editor.getTextWidget().getText();
        if (!newText.equals(this.currentText)) {
            this.saveState();
            this.currentText = newText;
        }
    }

    private void saveState() {
        if (this.isUndoing || this.isRedoing) {
            return;
        }
        this.undoStack.push(this.currentText);
        if (this.undoStack.size() > 100) {
            ArrayDeque<String> newStack = new ArrayDeque<String>();
            int count = 0;
            for (String state : this.undoStack) {
                if (count++ >= 100) continue;
                newStack.add(state);
            }
            this.undoStack = newStack;
        }
        this.redoStack.clear();
    }

    private void performUndo() {
        if (this.undoStack.size() <= 1 || this.isUndoing) {
            return;
        }
        this.isUndoing = true;
        this.redoStack.push(this.currentText);
        this.undoStack.pop();
        String previousText = this.undoStack.peek();
        this.editor.getTextWidget().setText(previousText);
        this.currentText = previousText;
        this.isUndoing = false;
    }

    private void performRedo() {
        if (this.redoStack.isEmpty() || this.isRedoing) {
            return;
        }
        this.isRedoing = true;
        String nextText = this.redoStack.pop();
        this.undoStack.push(nextText);
        this.editor.getTextWidget().setText(nextText);
        this.currentText = nextText;
        this.isRedoing = false;
    }

    private void resetStacks() {
        this.undoStack.clear();
        this.redoStack.clear();
        this.currentText = "";
    }

    public void clearHistory() {
        this.resetStacks();
    }

    public boolean canUndo() {
        return this.undoStack.size() > 1;
    }

    public boolean canRedo() {
        return !this.redoStack.isEmpty();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.resetStacks();
        }
    }
}

