/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.util.highlighter;

import io.github.zhengzhengyiyi.util.highlighter.HighLighter;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class YamlSyntaxHighlighter
implements HighLighter {
    @Override
    public int getCharIndexFromTokens(class_327 textRenderer, String line, int targetX) {
        if (line.isEmpty()) {
            return 0;
        }
        for (int i = 0; i <= line.length(); ++i) {
            int width = this.getTextWidthUpToChar(textRenderer, line, i);
            if (width < targetX) continue;
            return i;
        }
        return line.length();
    }

    @Override
    public int getTextWidthUpToChar(class_327 textRenderer, String line, int charIndex) {
        if (line.isEmpty() || charIndex <= 0) {
            return 0;
        }
        List<Token> tokens = this.tokenizeLine(line);
        int currentCharIndex = 0;
        int totalWidth = 0;
        for (Token token : tokens) {
            int tokenLength = token.content.length();
            if (currentCharIndex + tokenLength >= charIndex) {
                int charsInThisToken = charIndex - currentCharIndex;
                if (charsInThisToken <= 0) break;
                totalWidth += textRenderer.method_1727(token.content.substring(0, charsInThisToken));
                break;
            }
            totalWidth += textRenderer.method_1727(token.content);
            currentCharIndex += tokenLength;
        }
        return totalWidth;
    }

    @Override
    public void drawHighlightedText(class_332 context, class_327 textRenderer, String text, int x, int y, boolean editable) {
        if (text.isEmpty()) {
            return;
        }
        List<Token> tokens = this.tokenizeLine(text);
        int currentX = x;
        for (Token token : tokens) {
            int color = this.getTokenColor(token.type, editable);
            context.method_51433(textRenderer, token.content, currentX, y, color, false);
            currentX += textRenderer.method_1727(token.content);
        }
    }

    private List<Token> tokenizeLine(String line) {
        String keyPart;
        ArrayList<Token> tokens = new ArrayList<Token>();
        if (line.isEmpty()) {
            return tokens;
        }
        String trimmedLine = line.trim();
        if (trimmedLine.startsWith("#")) {
            tokens.add(new Token(TokenType.COMMENT, line));
            return tokens;
        }
        if (trimmedLine.equals("---") || trimmedLine.equals("...")) {
            tokens.add(new Token(TokenType.DOCUMENT_MARKER, line));
            return tokens;
        }
        if (trimmedLine.startsWith("- ")) {
            tokens.add(new Token(TokenType.LIST_ITEM, line));
            return tokens;
        }
        int colonIndex = line.indexOf(58);
        if (colonIndex == -1) {
            tokens.add(new Token(TokenType.TEXT, line));
            return tokens;
        }
        String beforeColon = line.substring(0, colonIndex);
        String afterColon = line.substring(colonIndex + 1);
        String indentation = this.extractIndentation(beforeColon);
        if (!indentation.isEmpty()) {
            tokens.add(new Token(TokenType.INDENTATION, indentation));
        }
        if (!(keyPart = beforeColon.trim()).isEmpty()) {
            tokens.add(new Token(TokenType.KEY, keyPart));
        }
        tokens.add(new Token(TokenType.COLON, ":"));
        if (!afterColon.isEmpty()) {
            String value = afterColon.trim();
            TokenType valueType = this.determineValueType(value);
            tokens.add(new Token(valueType, afterColon));
        }
        return tokens;
    }

    private String extractIndentation(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == ' ' || text.charAt(i) == '\t') continue;
            return text.substring(0, i);
        }
        return text;
    }

    private TokenType determineValueType(String value) {
        if (value.startsWith("\"") || value.startsWith("'")) {
            return TokenType.STRING_VALUE;
        }
        if (value.startsWith("- ")) {
            return TokenType.LIST_ITEM;
        }
        if (value.equals("true") || value.equals("false") || value.equals("yes") || value.equals("no")) {
            return TokenType.BOOLEAN_VALUE;
        }
        if (value.equals("null") || value.equals("~")) {
            return TokenType.NULL_VALUE;
        }
        if (value.matches("-?\\d+(\\.\\d+)?([eE][+-]?\\d+)?")) {
            return TokenType.NUMBER_VALUE;
        }
        return TokenType.VALUE;
    }

    @Override
    public int getTextWidth(class_327 textRenderer, String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        List<Token> tokens = this.tokenizeLine(text);
        int totalWidth = 0;
        for (Token token : tokens) {
            totalWidth += textRenderer.method_1727(token.content);
        }
        return totalWidth;
    }

    private int getTokenColor(TokenType type, boolean editable) {
        int defaultColor = editable ? -1 : -5592406;
        switch (type.ordinal()) {
            case 0: {
                return -9791147;
            }
            case 1: {
                return -10694413;
            }
            case 2: {
                return -5592406;
            }
            case 4: {
                return -1647756;
            }
            case 5: {
                return -5340673;
            }
            case 6: {
                return -11100970;
            }
            case 7: {
                return -448910;
            }
            case 8: {
                return -5840338;
            }
            case 9: {
                return -11184811;
            }
            case 10: {
                return -10496;
            }
            case 3: {
                return -1647756;
            }
        }
        return defaultColor;
    }

    @Environment(value=EnvType.CLIENT)
    private static class Token {
        public final TokenType type;
        public final String content;

        public Token(TokenType type, String content) {
            this.type = type;
            this.content = content;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum TokenType {
        COMMENT,
        KEY,
        COLON,
        VALUE,
        STRING_VALUE,
        NUMBER_VALUE,
        BOOLEAN_VALUE,
        NULL_VALUE,
        LIST_ITEM,
        INDENTATION,
        DOCUMENT_MARKER,
        TEXT;

    }
}

