/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.util;

import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class CodeSuggester {
    public static final Set<String> JSON_KEYWORDS = Set.of("true", "false", "null");
    private static final Set<String> COMMON_KEYS = Set.of("type", "name", "id", "count", "amount", "value", "data", "config", "enabled", "disabled", "width", "height", "x", "y", "z", "position", "color", "size", "speed", "duration", "delay", "interval", "random", "min", "max", "average", "total", "sum", "length", "weight", "price", "quality", "level", "tier", "rarity", "category", "group", "class", "version", "author", "description", "title", "label", "text", "message", "content", "items", "list", "array", "object", "properties", "settings", "options", "parameters", "args", "arguments", "input", "output", "result", "effect", "action", "event", "trigger", "condition", "requirement", "target", "source", "destination", "from", "to", "start", "end");
    private static final Map<String, Set<String>> KEY_VALUES = Map.of("type", Set.of("object", "array", "string", "number", "boolean", "integer"), "format", Set.of("json", "yaml", "xml", "csv", "text"), "mode", Set.of("read", "write", "append", "create", "delete", "update"), "status", Set.of("success", "error", "warning", "info", "pending", "completed"), "color", Set.of("red", "green", "blue", "yellow", "black", "white", "gray"), "direction", Set.of("up", "down", "left", "right", "forward", "backward"));
    public static final Pattern STRING_PATTERN = Pattern.compile("\"[^\"]*\"");
    public static final Pattern NUMBER_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");
    public static final Pattern KEY_PATTERN = Pattern.compile("\"([^\"]+)\"\\s*:");

    public static List<String> suggestForPosition(String jsonText, int cursorPosition) {
        String textAfterCursor;
        ArrayList<String> suggestions = new ArrayList<String>();
        if (jsonText == null || jsonText.isEmpty()) {
            suggestions.add("{");
            suggestions.add("[");
            return suggestions;
        }
        String textBeforeCursor = jsonText.substring(0, cursorPosition);
        if (CodeSuggester.isInKeyContext(textBeforeCursor, textAfterCursor = jsonText.substring(cursorPosition))) {
            suggestions.addAll(CodeSuggester.suggestKeys(textBeforeCursor));
        } else if (CodeSuggester.isInValueContext(textBeforeCursor, textAfterCursor)) {
            String currentKey = CodeSuggester.extractCurrentKey(textBeforeCursor);
            suggestions.addAll(CodeSuggester.suggestValues(currentKey, textBeforeCursor));
        } else if (CodeSuggester.isInStringContext(textBeforeCursor, textAfterCursor)) {
            suggestions.addAll(CodeSuggester.suggestStringContent(textBeforeCursor));
        }
        if (suggestions.isEmpty()) {
            suggestions.addAll(CodeSuggester.suggestStructural(jsonText, cursorPosition));
        }
        return CodeSuggester.filterDuplicates(suggestions);
    }

    private static boolean isInKeyContext(String before, String after) {
        int lastOpenBrace = before.lastIndexOf(123);
        int lastOpenBracket = before.lastIndexOf(91);
        int lastComma = before.lastIndexOf(44);
        int lastColon = before.lastIndexOf(58);
        return lastOpenBrace > lastColon && lastOpenBrace > lastComma || lastOpenBracket > lastColon && lastComma > lastColon || lastComma > lastColon && before.trim().endsWith(",");
    }

    private static boolean isInValueContext(String before, String after) {
        int lastColon = before.lastIndexOf(58);
        int lastOpenBrace = before.lastIndexOf(123);
        int lastOpenBracket = before.lastIndexOf(91);
        return lastColon > lastOpenBrace && lastColon > lastOpenBracket && !after.trim().startsWith("}") && !after.trim().startsWith("]");
    }

    private static boolean isInStringContext(String before, String after) {
        int secondLastQuote;
        int lastQuote = before.lastIndexOf(34);
        return lastQuote > (secondLastQuote = before.lastIndexOf(34, lastQuote - 1)) && lastQuote >= 0;
    }

    private static List<String> suggestKeys(String textBeforeCursor) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(COMMON_KEYS);
        keys.addAll(CodeSuggester.extractExistingKeys(textBeforeCursor));
        return keys.stream().map(key -> "\"" + key + "\": ").toList();
    }

    private static List<String> suggestValues(String currentKey, String textBeforeCursor) {
        ArrayList<String> values = new ArrayList<String>();
        if (KEY_VALUES.containsKey(currentKey)) {
            values.addAll((Collection)KEY_VALUES.get(currentKey));
        }
        values.add("\"\"");
        values.add("0");
        values.add("1");
        values.add("true");
        values.add("false");
        values.add("null");
        values.add("[]");
        values.add("{}");
        if ("count".equals(currentKey) || "amount".equals(currentKey) || "quantity".equals(currentKey)) {
            for (int i = 1; i <= 64; i *= 2) {
                values.add(String.valueOf(i));
            }
        }
        return values.stream().map(value -> {
            if (value.startsWith("\"") || value.equals("true") || value.equals("false") || value.equals("null") || value.equals("[]") || value.equals("{}")) {
                return value;
            }
            return "\"" + value + "\"";
        }).toList();
    }

    private static List<String> suggestStringContent(String textBeforeCursor) {
        ArrayList<String> suggestions = new ArrayList<String>();
        suggestions.add("text");
        suggestions.add("value");
        suggestions.add("data");
        suggestions.add("content");
        return suggestions;
    }

    private static List<String> suggestStructural(String jsonText, int cursorPosition) {
        ArrayList<String> suggestions;
        block4: {
            suggestions = new ArrayList<String>();
            try {
                JsonParser.parseString((String)jsonText);
                suggestions.add(",");
                suggestions.add("}");
                suggestions.add("]");
            }
            catch (JsonSyntaxException e) {
                String textBefore = jsonText.substring(0, cursorPosition);
                if (textBefore.trim().endsWith("{") || textBefore.trim().endsWith("[")) {
                    suggestions.add("\"\": ");
                }
                if (textBefore.trim().endsWith(":")) {
                    suggestions.add("\"\"");
                    suggestions.add("0");
                    suggestions.add("true");
                    suggestions.add("false");
                }
                if (!textBefore.trim().endsWith(",")) break block4;
                suggestions.add("\"\": ");
            }
        }
        return suggestions;
    }

    private static String extractCurrentKey(String textBeforeCursor) {
        String[] lines = textBeforeCursor.split("\n");
        for (int i = lines.length - 1; i >= 0; --i) {
            int colonIndex;
            String keyPart;
            String line = lines[i].trim();
            if (!line.contains(":") || !(keyPart = line.substring(0, colonIndex = line.indexOf(58)).trim()).startsWith("\"") || !keyPart.endsWith("\"")) continue;
            return keyPart.substring(1, keyPart.length() - 1);
        }
        return "";
    }

    private static Set<String> extractExistingKeys(String jsonText) {
        HashSet<String> keys = new HashSet<String>();
        Matcher matcher = KEY_PATTERN.matcher(jsonText);
        while (matcher.find()) {
            keys.add(matcher.group(1));
        }
        return keys;
    }

    private static List<String> filterDuplicates(List<String> list) {
        return new ArrayList<String>(new LinkedHashSet<String>(list));
    }

    public static List<String> getCommonKeys() {
        return new ArrayList<String>(COMMON_KEYS);
    }

    public static List<String> getValueSuggestions(String key) {
        return KEY_VALUES.getOrDefault(key, Collections.emptySet()).stream().toList();
    }
}

