/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.addon;

import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import io.github.zhengzhengyiyi.gui.EditorScreen;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;

public class DateTimeDisplayEntrypoint
implements ApiEntrypoint {
    private EditorScreen editor;
    private int xPos;
    private int yPos;

    @Override
    public void init() {
    }

    @Override
    public void onEditerOpen(EditorScreen editor) {
        this.editor = editor;
        this.yPos = 1;
    }

    @Override
    public void onEditerClose(EditorScreen editor) {
        this.editor = null;
    }

    @Override
    public InteractionResult onMouseDown(int x, int y) {
        return InteractionResult.PASS;
    }

    @Override
    public void onMouseScroll() {
    }

    @Override
    public ResourceLocation getIdentifier() {
        return ResourceLocation.fromNamespaceAndPath((String)"zhengzhengyiyi", (String)"datetime_display");
    }

    @Override
    public void renderButton(GuiGraphics context, int mouseX, int mouseY, float delta) {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String timeText = now.format(formatter);
        int textWidth = Minecraft.getInstance().font.width(timeText);
        this.xPos = this.editor.width / 2 + textWidth / 2;
        System.out.println("Rendering date/time at: " + this.xPos + ", " + this.yPos);
        context.drawString(Minecraft.getInstance().font, timeText, this.xPos, this.yPos, -256, false);
    }
}

