/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.addon;

import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import io.github.zhengzhengyiyi.gui.EditorScreen;
import io.github.zhengzhengyiyi.gui.widget.GeneralMultilineEditor;
import io.github.zhengzhengyiyi.gui.widget.MultilineEditor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.resources.ResourceLocation;

public class TextStatsEntrypoint
implements ApiEntrypoint {
    private boolean enabled = true;
    private EditorScreen editor;
    private int statsX = 80;
    private int statsY = 15;

    @Override
    public void init() {
    }

    @Override
    public ResourceLocation getIdentifier() {
        return ResourceLocation.fromNamespaceAndPath((String)"zhengzhengyiyi", (String)"text_stats_display");
    }

    @Override
    public void onEditerOpen(EditorScreen editor) {
        this.editor = editor;
        this.statsX = this.editor.width / 2 + 35;
        this.statsY = this.editor.height - 10;
    }

    @Override
    public void renderButton(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (!this.enabled || this.editor == null || this.editor.getTextWidget() == null) {
            return;
        }
        String text = "";
        AbstractWidget textWidget = this.editor.getTextWidget();
        if (textWidget instanceof MultilineEditor) {
            text = ((MultilineEditor)textWidget).text;
        } else if (textWidget instanceof GeneralMultilineEditor) {
            text = ((GeneralMultilineEditor)textWidget).text;
        } else {
            LOGGER.error("can not find current text");
        }
        int charCount = text.length();
        int wordCount = text.trim().isEmpty() ? 0 : text.split("\\s+").length;
        int lineCount = text.isEmpty() ? 0 : text.split("\n").length;
        String stats = "letter: " + charCount + " | words: " + wordCount + " | Lines: " + lineCount;
        context.drawString(Minecraft.getInstance().font, stats, this.statsX, this.statsY, -256, false);
    }
}

