/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.github.zhengzhengyiyi.gui.EditorScreen;
import io.github.zhengzhengyiyi.gui.widget.JsonFieldWidget;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;

public class JsonVisualEditorScreen
extends Screen {
    public final String originalJson;
    private JsonObject jsonObject;
    private final List<JsonFieldWidget> fieldWidgets = new ArrayList<JsonFieldWidget>();
    private final Map<String, Object> fieldValues = new LinkedHashMap<String, Object>();
    private int scrollOffset = 0;
    private static final int FIELD_HEIGHT = 30;
    public static final int MARGIN = 10;
    private static final int MAX_VISIBLE_FIELDS = 12;
    private Button saveButton;
    private Button cancelButton;
    private Button addFieldButton;
    private Button rawEditButton;
    private Button scrollUpButton;
    private Button scrollDownButton;

    public JsonVisualEditorScreen(String jsonContent) {
        super((Component)Component.translatable((String)"configeditor.visual.title"));
        this.originalJson = jsonContent;
        try {
            this.jsonObject = JsonParser.parseString((String)jsonContent).getAsJsonObject();
            for (Map.Entry entry : this.jsonObject.entrySet()) {
                this.fieldValues.put((String)entry.getKey(), this.jsonElementToValue((JsonElement)entry.getValue()));
            }
        }
        catch (JsonSyntaxException | IllegalStateException e) {
            this.jsonObject = new JsonObject();
        }
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int buttonWidth = 100;
        int buttonHeight = 20;
        this.saveButton = Button.builder((Component)Component.translatable((String)"configeditor.button.save"), button -> this.saveChanges()).bounds(centerX - 110, this.height - 30, buttonWidth, buttonHeight).build();
        this.cancelButton = Button.builder((Component)Component.translatable((String)"configeditor.button.close"), button -> this.onClose()).bounds(centerX + 10, this.height - 30, buttonWidth, buttonHeight).build();
        this.addFieldButton = Button.builder((Component)Component.translatable((String)"configeditor.visual.addfield"), button -> this.addNewField()).bounds(centerX - buttonWidth / 2, this.height - 60, buttonWidth, buttonHeight).build();
        this.rawEditButton = Button.builder((Component)Component.translatable((String)"configeditor.visual.rawedit"), button -> this.returnToRawEditor()).bounds(this.width - 110, 10, 100, buttonHeight).build();
        this.scrollUpButton = Button.builder((Component)Component.literal((String)"\u2191"), button -> this.scrollUp()).bounds(this.width - 40, 50, 30, 20).build();
        this.scrollDownButton = Button.builder((Component)Component.literal((String)"\u2193"), button -> this.scrollDown()).bounds(this.width - 40, this.height - 120, 30, 20).build();
        this.addRenderableWidget((GuiEventListener)this.saveButton);
        this.addRenderableWidget((GuiEventListener)this.cancelButton);
        this.addRenderableWidget((GuiEventListener)this.addFieldButton);
        this.addRenderableWidget((GuiEventListener)this.rawEditButton);
        this.addRenderableWidget((GuiEventListener)this.scrollUpButton);
        this.addRenderableWidget((GuiEventListener)this.scrollDownButton);
        this.rebuildFieldWidgets();
        this.updateScrollButtons();
    }

    private void rebuildFieldWidgets() {
        for (JsonFieldWidget widget2 : this.fieldWidgets) {
            this.removeWidget((GuiEventListener)widget2);
        }
        this.fieldWidgets.clear();
        int yPos = 50;
        int centerX = this.width / 2;
        int maxFieldsToShow = Math.min(12, this.fieldValues.size() - this.scrollOffset);
        ArrayList<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>(this.fieldValues.entrySet());
        for (int i = this.scrollOffset; i < this.scrollOffset + maxFieldsToShow && i < entries.size(); ++i) {
            Map.Entry entry = (Map.Entry)entries.get(i);
            JsonFieldWidget fieldWidget = new JsonFieldWidget((String)entry.getKey(), entry.getValue(), centerX - 150, yPos, 300, 30, (Component)Component.literal((String)""), widget -> {
                String oldKey = (String)entry.getKey();
                String newKey = widget.getKey();
                Object newValue = widget.getValue();
                if (!oldKey.equals(newKey)) {
                    this.fieldValues.remove(oldKey);
                }
                this.fieldValues.put(newKey, newValue);
                this.rebuildFieldWidgets();
            });
            this.fieldWidgets.add(fieldWidget);
            this.addRenderableWidget((GuiEventListener)fieldWidget);
            yPos += 35;
        }
    }

    private void scrollUp() {
        if (this.scrollOffset > 0) {
            --this.scrollOffset;
            this.rebuildFieldWidgets();
            this.updateScrollButtons();
        }
    }

    private void scrollDown() {
        if (this.scrollOffset < this.fieldValues.size() - 12) {
            ++this.scrollOffset;
            this.rebuildFieldWidgets();
            this.updateScrollButtons();
        }
    }

    private void updateScrollButtons() {
        this.scrollUpButton.active = this.scrollOffset > 0;
        this.scrollDownButton.active = this.scrollOffset < Math.max(0, this.fieldValues.size() - 12);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int centerX = this.width / 2;
        context.drawCenteredString(this.font, (Component)Component.translatable((String)"configeditor.visual.title"), centerX, 20, 0xFFFFFF);
        String fieldCountText = Component.translatable((String)"configeditor.visual.fieldcount", (Object[])new Object[]{this.fieldValues.size()}).getString();
        context.drawString(this.font, fieldCountText, centerX - 150, 35, 0xAAAAAA);
        if (this.scrollOffset > 0) {
            context.drawString(this.font, "... \u2191 ...", centerX - 150, 45, 0x888888);
        }
        if (this.scrollOffset + 12 < this.fieldValues.size()) {
            int bottomTextY = 470;
            context.drawString(this.font, "... \u2193 ...", centerX - 150, bottomTextY, 0x888888);
        }
        super.render(context, mouseX, mouseY, delta);
        for (JsonFieldWidget widget : this.fieldWidgets) {
            if (!widget.isMouseOver(mouseX, mouseY)) continue;
            widget.renderTooltip(context, mouseX, mouseY);
        }
        if (this.fieldWidgets.isEmpty()) {
            context.drawCenteredString(this.font, (Component)Component.translatable((String)"configeditor.visual.empty"), centerX, this.height / 2, 0x888888);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (verticalAmount > 0.0) {
            this.scrollUp();
            return true;
        }
        if (verticalAmount < 0.0) {
            this.scrollDown();
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void saveChanges() {
        JsonObject updatedJson = new JsonObject();
        boolean hasErrors = false;
        for (JsonFieldWidget widget : this.fieldWidgets) {
            String key = widget.getKey();
            Object value = widget.getValue();
            if (key == null || key.trim().isEmpty()) continue;
            try {
                if (value instanceof String) {
                    String strValue = (String)value;
                    updatedJson.addProperty(key, strValue);
                    continue;
                }
                if (value instanceof Boolean) {
                    Boolean boolValue = (Boolean)value;
                    updatedJson.addProperty(key, boolValue);
                    continue;
                }
                if (value instanceof Integer) {
                    Integer intValue = (Integer)value;
                    updatedJson.addProperty(key, (Number)intValue);
                    continue;
                }
                if (value instanceof Double) {
                    Double doubleValue = (Double)value;
                    updatedJson.addProperty(key, (Number)doubleValue);
                    continue;
                }
                if (value == null) {
                    updatedJson.add(key, null);
                    continue;
                }
                updatedJson.addProperty(key, value.toString());
            }
            catch (Exception e) {
                hasErrors = true;
                widget.setError(true);
            }
        }
        if (!hasErrors) {
            String newJson = updatedJson.toString();
            if (this.minecraft != null && this.minecraft.screen instanceof EditorScreen) {
                EditorScreen editorScreen = (EditorScreen)this.minecraft.screen;
                editorScreen.setEditorText(newJson);
                editorScreen.showMessagePopup((Component)Component.translatable((String)"configeditor.message.saved"));
                this.onClose();
            }
        } else {
            this.showErrorPopup((Component)Component.translatable((String)"configeditor.error.invalidjson"));
        }
    }

    private void addNewField() {
        String baseKey = Component.translatable((String)"configeditor.visual.newfield").getString();
        String newKey = baseKey + "_" + (this.fieldValues.size() + 1);
        this.fieldValues.put(newKey, "");
        if (this.scrollOffset < this.fieldValues.size() - 12) {
            this.scrollOffset = Math.max(0, this.fieldValues.size() - 12);
        }
        this.rebuildFieldWidgets();
        this.updateScrollButtons();
    }

    private Object jsonElementToValue(JsonElement element) {
        if (element.isJsonPrimitive()) {
            if (element.getAsJsonPrimitive().isString()) {
                return element.getAsString();
            }
            if (element.getAsJsonPrimitive().isBoolean()) {
                return element.getAsBoolean();
            }
            if (element.getAsJsonPrimitive().isNumber()) {
                try {
                    return element.getAsInt();
                }
                catch (Exception e) {
                    return element.getAsDouble();
                }
            }
        } else {
            if (element.isJsonNull()) {
                return null;
            }
            if (element.isJsonArray() || element.isJsonObject()) {
                return element.toString();
            }
        }
        return "";
    }

    private void returnToRawEditor() {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)new EditorScreen());
        }
    }

    private void showErrorPopup(Component message) {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)new GenericMessageScreen(message));
        }
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)new EditorScreen());
        }
        super.onClose();
    }

    public boolean keyPressed(KeyEvent input) {
        if (input.input() == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(input);
    }
}

