/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.zhengzhengyiyi.gui.widget.MultilineEditor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public class NbtEditorScreen
extends Screen {
    private Optional<CompoundTag> nbtData = Optional.empty();
    private EditBox nameField;
    private MultilineEditor contentField;
    private EditBox renameField;
    private final Minecraft client = Minecraft.getInstance();

    public NbtEditorScreen(CompoundTag nbtData) {
        super(Component.nullToEmpty((String)"NBT Editor"));
        this.nbtData = Optional.ofNullable(nbtData);
    }

    protected void init() {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        this.nameField = new EditBox(this.font, centerX - 100, centerY - 80, 200, 20, Component.nullToEmpty((String)"Original Name"));
        this.contentField = new MultilineEditor(centerX - 100, centerY - 50, 200, 100, Component.nullToEmpty((String)"NBT Content"));
        this.renameField = new EditBox(this.font, centerX - 100, centerY + 70, 200, 20, Component.nullToEmpty((String)"Save File Name"));
        this.nameField.setValue(this.nbtData.flatMap(nbt -> nbt.getString("Name")).orElse(""));
        this.contentField.setText(this.nbtToJsonString(this.nbtData.orElse(new CompoundTag())));
        this.renameField.setValue(this.nameField.getValue());
        this.addWidget((GuiEventListener)this.nameField);
        this.addWidget((GuiEventListener)this.contentField);
        this.addWidget((GuiEventListener)this.renameField);
        Button saveButton = Button.builder((Component)Component.nullToEmpty((String)"Save"), button -> this.saveNbt()).bounds(centerX - 110, centerY + 100, 100, 20).build();
        Button closeButton = Button.builder((Component)Component.nullToEmpty((String)"Close"), button -> this.client.setScreen(null)).bounds(centerX + 10, centerY + 100, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)saveButton);
        this.addRenderableWidget((GuiEventListener)closeButton);
    }

    private String nbtToJsonString(CompoundTag nbt) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        JsonObject jsonObject = new JsonObject();
        Set keys = nbt.keySet();
        for (String key : keys) {
            Tag element = nbt.get(key);
            jsonObject.addProperty(key, element.toString());
        }
        return gson.toJson((JsonElement)jsonObject);
    }

    private void saveNbt() {
        String fileName = this.renameField.getValue().trim();
        if (!fileName.isEmpty() && this.nbtData.isPresent()) {
            File saveDir = new File(Minecraft.getInstance().gameDirectory, "saved_nbt");
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            File outFile = new File(saveDir, fileName + ".json");
            try (FileWriter writer = new FileWriter(outFile);){
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                JsonElement jsonElement = JsonParser.parseString((String)this.nbtToJsonString(this.nbtData.get()));
                gson.toJson(jsonElement, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.client.setScreen(null);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.nameField.render(context, mouseX, mouseY, delta);
        this.contentField.render(context, mouseX, mouseY, delta);
        this.renameField.render(context, mouseX, mouseY, delta);
    }
}

