/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.gui.widget;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public class JsonFieldWidget
extends AbstractWidget {
    private EditBox keyField;
    private EditBox valueField;
    private Button deleteButton;
    private Button typeButton;
    private String currentType;
    private boolean hasError = false;
    private final Consumer<JsonFieldWidget> onChange;
    private String originalKey;

    public JsonFieldWidget(String key, Object value, int x, int y, int width, int height, Component message, Consumer<JsonFieldWidget> onChange) {
        super(x, y, width, height, message);
        this.onChange = onChange;
        this.originalKey = key;
        Font textRenderer = Minecraft.getInstance().font;
        int fieldHeight = 20;
        this.keyField = new EditBox(textRenderer, x + 5, y + 5, width / 2 - 40, fieldHeight, (Component)Component.translatable((String)"configeditor.visual.key"));
        this.keyField.setValue(key == null ? "" : key);
        this.keyField.setMaxLength(100);
        this.keyField.setResponder(text -> this.notifyChange());
        this.determineType(value);
        this.valueField = new EditBox(textRenderer, x + width / 2 + 5, y + 5, width / 2 - 70, fieldHeight, (Component)Component.translatable((String)"configeditor.visual.value"));
        this.valueField.setValue(this.valueToString(value));
        this.valueField.setMaxLength(500);
        this.valueField.setResponder(text -> {
            this.validateValue();
            this.notifyChange();
        });
        this.typeButton = Button.builder((Component)Component.literal((String)this.getTypeSymbol()), button -> this.toggleType()).bounds(x + width - 100, y + 5, 30, fieldHeight).build();
        this.deleteButton = Button.builder((Component)Component.literal((String)"\u00d7"), button -> {
            if (this.onChange != null) {
                this.onChange.accept(this);
            }
        }).bounds(x + width - 65, y + 5, 20, fieldHeight).build();
    }

    private String valueToString(Object value) {
        if (value == null) {
            return "null";
        }
        return String.valueOf(value);
    }

    private void determineType(Object value) {
        this.currentType = value == null ? "null" : (value instanceof Boolean ? "boolean" : (value instanceof Number ? "number" : "string"));
    }

    private String getTypeSymbol() {
        return switch (this.currentType) {
            case "string" -> "\"\"";
            case "number" -> "123";
            case "boolean" -> "T/F";
            case "null" -> "\u2205";
            default -> "?";
        };
    }

    private void toggleType() {
        this.currentType = switch (this.currentType) {
            case "string" -> "number";
            case "number" -> "boolean";
            case "boolean" -> "null";
            case "null" -> "string";
            default -> "string";
        };
        this.typeButton.setMessage((Component)Component.literal((String)this.getTypeSymbol()));
        if (this.currentType.equals("boolean")) {
            this.valueField.setValue("true");
        } else if (this.currentType.equals("null")) {
            this.valueField.setValue("null");
        } else if (this.currentType.equals("number")) {
            this.valueField.setValue("0");
        }
        this.validateValue();
        this.notifyChange();
    }

    private void validateValue() {
        String text = this.valueField.getValue();
        this.hasError = false;
        try {
            switch (this.currentType) {
                case "number": {
                    Double.parseDouble(text);
                    break;
                }
                case "boolean": {
                    if (text.equals("true") || text.equals("false")) break;
                    this.hasError = true;
                    break;
                }
                case "null": {
                    if (text.equals("null")) break;
                    this.hasError = true;
                }
            }
        }
        catch (NumberFormatException e) {
            this.hasError = true;
        }
    }

    private void notifyChange() {
        if (this.onChange != null) {
            this.onChange.accept(this);
        }
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int bgColor = this.hasError ? 822039893 : 0x20FFFFFF;
        Font textRenderer = Minecraft.getInstance().font;
        context.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, bgColor);
        this.keyField.render(context, mouseX, mouseY, delta);
        context.drawString(textRenderer, ":", this.getX() + this.width / 2 - 10, this.getY() + 10, 0xFFFFFF);
        this.valueField.render(context, mouseX, mouseY, delta);
        this.typeButton.render(context, mouseX, mouseY, delta);
        this.deleteButton.render(context, mouseX, mouseY, delta);
        String typeLabel = this.getTypeLabel();
        context.drawString(textRenderer, typeLabel, this.getX() + this.width - 40, this.getY() + 10, this.getTypeColor());
    }

    private String getTypeLabel() {
        return switch (this.currentType) {
            case "string" -> Component.translatable((String)"configeditor.visual.type.string").getString();
            case "number" -> Component.translatable((String)"configeditor.visual.type.number").getString();
            case "boolean" -> Component.translatable((String)"configeditor.visual.type.boolean").getString();
            case "null" -> Component.translatable((String)"configeditor.visual.type.null").getString();
            default -> Component.translatable((String)"configeditor.visual.type.unknown").getString();
        };
    }

    private int getTypeColor() {
        return switch (this.currentType) {
            case "string" -> 0x55FF55;
            case "number" -> 0x5555FF;
            case "boolean" -> 0xFFAA00;
            case "null" -> 0xFF5555;
            default -> 0xAAAAAA;
        };
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        if (this.keyField.mouseClicked(click, doubled)) {
            return true;
        }
        if (this.valueField.mouseClicked(click, doubled)) {
            return true;
        }
        if (this.typeButton.mouseClicked(click, doubled)) {
            return true;
        }
        if (this.deleteButton.mouseClicked(click, doubled)) {
            return true;
        }
        return super.mouseClicked(click, doubled);
    }

    public boolean keyPressed(KeyEvent input) {
        if (this.keyField.isFocused()) {
            return this.keyField.keyPressed(input);
        }
        if (this.valueField.isFocused()) {
            return this.valueField.keyPressed(input);
        }
        return false;
    }

    public boolean charTyped(CharacterEvent input) {
        if (this.keyField.isFocused()) {
            return this.keyField.charTyped(input);
        }
        if (this.valueField.isFocused()) {
            return this.valueField.charTyped(input);
        }
        return false;
    }

    public String getKey() {
        return this.keyField.getValue();
    }

    public String getOriginalKey() {
        return this.originalKey;
    }

    public Object getValue() {
        String text = this.valueField.getValue();
        try {
            return switch (this.currentType) {
                case "number" -> text.contains(".") ? Double.parseDouble(text) : (double)Integer.parseInt(text);
                case "boolean" -> Boolean.parseBoolean(text);
                case "null" -> null;
                default -> text;
            };
        }
        catch (NumberFormatException e) {
            return text;
        }
    }

    public void setError(boolean error) {
        this.hasError = error;
    }

    public void renderTooltip(GuiGraphics context, int mouseX, int mouseY) {
        Font textRenderer = Minecraft.getInstance().font;
        if (this.typeButton.isMouseOver((double)mouseX, (double)mouseY)) {
            context.setTooltipForNextFrame(textRenderer, (Component)Component.translatable((String)"configeditor.visual.tooltip.type", (Object[])new Object[]{this.getTypeLabel()}), mouseX, mouseY);
        } else if (this.deleteButton.isMouseOver((double)mouseX, (double)mouseY)) {
            context.setTooltipForNextFrame(textRenderer, (Component)Component.translatable((String)"configeditor.visual.tooltip.delete"), mouseX, mouseY);
        } else if (this.hasError) {
            context.setTooltipForNextFrame(textRenderer, (Component)Component.translatable((String)"configeditor.visual.tooltip.error"), mouseX, mouseY);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
        builder.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"configeditor.title"));
    }
}

